/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.ConstantReflectionProvider;

@NodeInfo
public final class PiArrayNode
extends PiNode
implements ArrayLengthProvider {
    public static final NodeClass<PiArrayNode> TYPE = NodeClass.create(PiArrayNode.class);
    @Node.Input
    ValueNode length;

    @Override
    public ValueNode findLength(ArrayLengthProvider.FindLengthMode mode, ConstantReflectionProvider constantReflection) {
        return this.length;
    }

    public PiArrayNode(ValueNode object, ValueNode length, Stamp stamp) {
        super(TYPE, object, stamp, null);
        this.length = length;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (GraphUtil.arrayLength(this.object(), ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, tool.getConstantReflection()) != this.length) {
            return this;
        }
        return super.canonical(tool);
    }

    @Node.NodeIntrinsic(value=Placeholder.class)
    public static native Object piArrayCastToSnippetReplaceeStamp(Object var0, int var1);

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static class Placeholder
    extends PiNode.Placeholder {
        public static final NodeClass<Placeholder> TYPE = NodeClass.create(Placeholder.class);
        @Node.Input
        ValueNode length;

        protected Placeholder(ValueNode object, ValueNode length) {
            super(TYPE, object);
            this.length = length;
        }

        @Override
        public void makeReplacement(Stamp snippetReplaceeStamp) {
            PiArrayNode piArray = this.graph().addOrUnique(new PiArrayNode(this.object(), this.length, snippetReplaceeStamp));
            this.replaceAndDelete(piArray);
        }
    }
}

