/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.List;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.BinaryOpLogicNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FloatingGuardedNode;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.UnaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
@Node.NodeIntrinsicFactory
public class PiNode
extends FloatingGuardedNode
implements LIRLowerable,
Virtualizable,
Canonicalizable,
ValueProxy {
    public static final NodeClass<PiNode> TYPE = NodeClass.create(PiNode.class);
    @Node.Input
    ValueNode object;
    protected Stamp piStamp;
    private static final int MAX_PI_USAGE_ITERATIONS = 8;

    public ValueNode object() {
        return this.object;
    }

    protected PiNode(NodeClass<? extends PiNode> c, ValueNode object, Stamp stamp, GuardingNode guard) {
        super(c, stamp, guard);
        this.object = object;
        this.piStamp = stamp;
        assert (this.piStamp.isCompatible(object.stamp(NodeView.DEFAULT))) : "Object stamp not compatible to piStamp";
        this.inferStamp();
    }

    public PiNode(ValueNode object, Stamp stamp) {
        this(object, stamp, null);
    }

    public PiNode(ValueNode object, Stamp stamp, ValueNode guard) {
        this(TYPE, object, stamp, (GuardingNode)((Object)guard));
    }

    public PiNode(ValueNode object, ValueNode guard) {
        this(object, AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT)), guard);
    }

    public PiNode(ValueNode object, ResolvedJavaType toType, boolean exactType, boolean nonNull) {
        this(object, (Stamp)StampFactory.object(exactType ? TypeReference.createExactTrusted(toType) : TypeReference.createWithoutAssumptions(toType), nonNull || StampTool.isPointerNonNull(object.stamp(NodeView.DEFAULT))));
    }

    public static ValueNode create(ValueNode object, Stamp stamp) {
        ValueNode value = PiNode.canonical(object, stamp, null, null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp);
    }

    public static ValueNode create(ValueNode object, Stamp stamp, ValueNode guard) {
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp, guard);
    }

    public static ValueNode create(ValueNode object, ValueNode guard) {
        Stamp stamp = AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT));
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp, guard);
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode input, ValueNode guard, IntrinsifyOp intrinsifyOp) {
        Stamp piStamp;
        JavaKind pushKind = switch (intrinsifyOp.ordinal()) {
            case 0 -> {
                piStamp = AbstractPointerStamp.pointerNonNull(input.stamp(NodeView.DEFAULT));
                yield JavaKind.Object;
            }
            case 1 -> {
                piStamp = StampFactory.positiveInt();
                yield JavaKind.Int;
            }
            case 2 -> {
                piStamp = StampFactory.nonZeroInt();
                yield JavaKind.Int;
            }
            case 3 -> {
                piStamp = StampFactory.nonZeroLong();
                yield JavaKind.Long;
            }
            case 5 -> {
                piStamp = new FloatStamp(32, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
                yield JavaKind.Float;
            }
            case 4 -> {
                piStamp = new FloatStamp(64, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, true);
                yield JavaKind.Double;
            }
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)intrinsifyOp);
        };
        ValueNode value = PiNode.canonical(input, piStamp, (GuardingNode)((Object)guard), null);
        if (value == null) {
            value = new PiNode(input, piStamp, guard);
        }
        b.push(pushKind, b.append(value));
        return true;
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode object, ResolvedJavaType toType, boolean exactType, boolean nonNull, ValueNode guard) {
        ObjectStamp stamp = StampFactory.object(exactType ? TypeReference.createExactTrusted(toType) : TypeReference.createWithoutAssumptions(toType), nonNull || StampTool.isPointerNonNull(object.stamp(NodeView.DEFAULT)));
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value == null) {
            value = new PiNode(object, (Stamp)stamp);
        }
        b.push(JavaKind.Object, b.append(value));
        return true;
    }

    public final Stamp piStamp() {
        return this.piStamp;
    }

    public void strengthenPiStamp(Stamp newPiStamp) {
        assert (this.piStamp.join(newPiStamp).equals(newPiStamp)) : "stamp can only improve";
        this.piStamp = newPiStamp;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (generator.hasOperand(this.object)) {
            generator.setResult(this, generator.operand(this.object));
        }
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.computeStamp());
    }

    private Stamp computeStamp() {
        return this.piStamp.improveWith(this.object().stamp(NodeView.DEFAULT));
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            ResolvedJavaType type = StampTool.typeOrNull(this, tool.getMetaAccess());
            if (type != null && type.isAssignableFrom(virtual.type())) {
                tool.replaceWithVirtual(virtual);
            } else {
                tool.getDebug().log(2, "could not virtualize Pi because of type mismatch: %s %s vs %s", (Object)this, (Object)type, (Object)virtual.type());
            }
        }
    }

    @SuppressFBWarnings(value={"NP"}, justification="We null check it before")
    public static ValueNode canonical(ValueNode object, Stamp piStamp, GuardingNode guard, ValueNode self) {
        GraalError.guarantee(piStamp != null && object != null, "Invariant piStamp=%s object=%s guard=%s self=%s", (Object)piStamp, (Object)object, (Object)guard, (Object)self);
        Stamp computedStamp = piStamp.improveWith(object.stamp(NodeView.DEFAULT));
        if (computedStamp.equals(object.stamp(NodeView.DEFAULT))) {
            return object;
        }
        if (guard == null) {
            if (object instanceof ReadNode && !object.hasMoreThanOneUsage()) {
                ReadNode readNode = (ReadNode)object;
                readNode.setStamp(readNode.stamp(NodeView.DEFAULT).improveWith(piStamp));
                return readNode;
            }
        } else {
            for (Node n : guard.asNode().usages()) {
                Stamp joinedPiStamp;
                if (!(n instanceof PiNode) || n == self) continue;
                PiNode otherPi = (PiNode)n;
                if (otherPi.guard != guard) {
                    assert (otherPi.object() == guard) : Assertions.errorMessageContext("object", object, "otherPi", otherPi, "guard", guard);
                    continue;
                }
                if (otherPi.object() != self && otherPi.object() != object || (joinedPiStamp = piStamp.improveWith(otherPi.piStamp())).equals(piStamp)) continue;
                if (otherPi.object() == object && joinedPiStamp.equals(otherPi.piStamp())) {
                    return otherPi;
                }
                if (self == null || !self.hasExactlyOneUsage() || otherPi.object != self || !joinedPiStamp.equals(otherPi.piStamp)) continue;
                return object;
            }
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode value = PiNode.canonical(this.object(), this.piStamp(), this.getGuard(), this);
        if (value != null) {
            return value;
        }
        if (tool.allUsagesAvailable()) {
            for (Node usage : this.usages()) {
                if (usage instanceof VirtualState) continue;
                return this;
            }
            return this.object;
        }
        return this;
    }

    public static void tryEvacuate(SimplifierTool tool, GuardingNode guard) {
        PiNode.tryEvacuate(tool, guard, true);
    }

    private static void tryEvacuate(SimplifierTool tool, GuardingNode guard, boolean recurse) {
        ValueNode guardNode = guard.asNode();
        if (guardNode.hasNoUsages()) {
            return;
        }
        List<PiNode> pis = guardNode.usages().filter(PiNode.class).snapshot();
        for (PiNode pi : pis) {
            Node canonical;
            GuardingNode otherGuard;
            if (!pi.isAlive()) continue;
            if (pi.hasNoUsages()) {
                pi.safeDelete();
                continue;
            }
            if (recurse && pi.getOriginalNode() instanceof PiNode && (otherGuard = ((PiNode)pi.getOriginalNode()).guard) != null) {
                PiNode.tryEvacuate(tool, otherGuard, false);
            }
            if (!pi.isAlive() || (canonical = pi.canonical(tool)) == pi) continue;
            if (!canonical.isAlive()) {
                canonical = guardNode.graph().addOrUniqueWithInputs(canonical);
            }
            pi.replaceAtUsages(canonical);
            pi.safeDelete();
        }
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.object;
    }

    public void setOriginalNode(ValueNode newNode) {
        this.updateUsages(this.object, newNode);
        this.object = newNode;
        assert (this.piStamp.isCompatible(this.object.stamp(NodeView.DEFAULT))) : "New object stamp not compatible to piStamp";
    }

    @Node.NodeIntrinsic(value=Placeholder.class)
    public static native Object piCastToSnippetReplaceeStamp(Object var0);

    public static int piCastPositive(int value, GuardingNode guard) {
        return PiNode.intrinsified(value, guard, IntrinsifyOp.POSITIVE_INT);
    }

    public static int piCastNonZero(int value, GuardingNode guard) {
        return PiNode.intrinsified(value, guard, IntrinsifyOp.INT_NON_ZERO);
    }

    public static long piCastNonZero(long value, GuardingNode guard) {
        return PiNode.intrinsified(value, guard, IntrinsifyOp.LONG_NON_ZERO);
    }

    @Node.NodeIntrinsic
    private static native int intrinsified(int var0, GuardingNode var1, @Node.ConstantNodeParameter IntrinsifyOp var2);

    @Node.NodeIntrinsic
    private static native long intrinsified(long var0, GuardingNode var2, @Node.ConstantNodeParameter IntrinsifyOp var3);

    public static Object piCastNonNull(Object object, GuardingNode guard) {
        return PiNode.intrinsified(object, guard, IntrinsifyOp.NON_NULL);
    }

    @Node.NodeIntrinsic
    private static native Object intrinsified(Object var0, GuardingNode var1, @Node.ConstantNodeParameter IntrinsifyOp var2);

    public static Class<?> piCastNonNullClass(Class<?> type, GuardingNode guard) {
        return PiNode.intrinsified(type, guard, IntrinsifyOp.NON_NULL);
    }

    public static float piCastNonNanFloat(float input, GuardingNode guard) {
        return PiNode.intrinsified(input, guard, IntrinsifyOp.FLOAT_NON_NAN);
    }

    @Node.NodeIntrinsic
    private static native float intrinsified(float var0, GuardingNode var1, @Node.ConstantNodeParameter IntrinsifyOp var2);

    public static double piCastNonNanDouble(double input, GuardingNode guard) {
        return PiNode.intrinsified(input, guard, IntrinsifyOp.DOUBLE_NON_NAN);
    }

    @Node.NodeIntrinsic
    private static native double intrinsified(double var0, GuardingNode var2, @Node.ConstantNodeParameter IntrinsifyOp var3);

    @Node.NodeIntrinsic
    private static native Class<?> intrinsified(Class<?> var0, GuardingNode var1, @Node.ConstantNodeParameter IntrinsifyOp var2);

    @Node.NodeIntrinsic
    public static native Object piCast(Object var0, @Node.ConstantNodeParameter ResolvedJavaType var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, GuardingNode var4);

    @Node.NodeIntrinsic
    public static native Object piCast(Object var0, @Node.ConstantNodeParameter Class<?> var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3, GuardingNode var4);

    public static boolean guardTrySkipPi(GuardingNode guard, LogicNode condition, boolean negated, NodeView nodeView) {
        if (!(guard instanceof FixedGuardNode || guard instanceof GuardNode || guard instanceof BeginNode)) {
            return false;
        }
        LogicNode usagePiCondition = condition;
        if (usagePiCondition.inputs().filter(PiNode.class).isEmpty()) {
            return false;
        }
        int iterations = 0;
        boolean progress = true;
        int pisSkipped = 0;
        block0: while (progress && iterations++ < 8) {
            progress = false;
            for (PiNode usagePi : PiNode.piUsageSnapshot(guard)) {
                boolean piProvenByCondition;
                PiNode inputPi;
                ValueNode usagePiObject;
                boolean usagePiObjectRegularPi;
                if (!usagePi.isRegularPi() || !(usagePiObjectRegularPi = (usagePiObject = usagePi.object()) instanceof PiNode && (inputPi = (PiNode)usagePiObject).isRegularPi()) || !usagePiCondition.inputs().contains(usagePiObject)) continue;
                Stamp usagePiPiStamp = usagePi.piStamp();
                PiNode inputPi2 = (PiNode)usagePiObject;
                Stamp succeedingStamp = null;
                if (usagePiCondition instanceof UnaryOpLogicNode) {
                    UnaryOpLogicNode uol = (UnaryOpLogicNode)usagePiCondition;
                    succeedingStamp = uol.getSucceedingStampForValue(negated);
                } else if (usagePiCondition instanceof BinaryOpLogicNode) {
                    BinaryOpLogicNode bol = (BinaryOpLogicNode)usagePiCondition;
                    if (bol.getX() == inputPi2) {
                        succeedingStamp = bol.getSucceedingStampForX(negated, bol.getX().stamp(nodeView), bol.getY().stamp(nodeView).unrestricted());
                    } else if (bol.getY() == inputPi2) {
                        succeedingStamp = bol.getSucceedingStampForY(negated, bol.getX().stamp(nodeView).unrestricted(), bol.getY().stamp(nodeView));
                    }
                }
                boolean bl = piProvenByCondition = succeedingStamp != null && usagePiPiStamp.equals(succeedingStamp);
                if (!piProvenByCondition) continue;
                Stamp inputPiPiStamp = inputPi2.piStamp();
                Stamp inputPiObjectStamp = inputPi2.object().stamp(nodeView);
                Stamp resultStampWithInputPiObjectOnly = usagePiPiStamp.improveWith(inputPiObjectStamp);
                boolean resultPiEquallyStrongWithoutInputPiPiStamp = resultStampWithInputPiObjectOnly.tryImproveWith(inputPiPiStamp) == null;
                if (!resultPiEquallyStrongWithoutInputPiPiStamp) continue;
                ValueNode resultPi = usagePiCondition.graph().addOrUnique(PiNode.create(inputPi2.object(), usagePiPiStamp, usagePi.getGuard().asNode()));
                LogicNode resultPiCondition = (LogicNode)usagePiCondition.copyWithInputs(true);
                resultPiCondition.replaceAllInputs(usagePiObject, inputPi2.object());
                ValueNode valueNode = guard.asNode();
                if (valueNode instanceof FixedGuardNode) {
                    FixedGuardNode fg = (FixedGuardNode)valueNode;
                    fg.setCondition(resultPiCondition, negated);
                } else {
                    valueNode = guard.asNode();
                    if (valueNode instanceof GuardNode) {
                        GuardNode floatingGuard = (GuardNode)valueNode;
                        floatingGuard.setCondition(resultPiCondition, negated);
                    } else if (guard.asNode() instanceof BeginNode) {
                        ((IfNode)guard.asNode().predecessor()).setCondition(resultPiCondition);
                    } else {
                        GraalError.shouldNotReachHere("Unknown guard " + String.valueOf(guard));
                    }
                }
                usagePi.replaceAndDelete(resultPi);
                progress = true;
                ++pisSkipped;
                continue block0;
            }
        }
        return pisSkipped > 0;
    }

    private boolean isRegularPi() {
        return this.getClass() == PiNode.class;
    }

    private static Iterable<PiNode> piUsageSnapshot(GuardingNode guard) {
        return guard.asNode().usages().filter(PiNode.class).snapshot();
    }

    public static enum IntrinsifyOp {
        NON_NULL,
        POSITIVE_INT,
        INT_NON_ZERO,
        LONG_NON_ZERO,
        DOUBLE_NON_NAN,
        FLOAT_NON_NAN;

    }

    public static final class PlaceholderStamp
    extends ObjectStamp {
        private static final PlaceholderStamp SINGLETON = new PlaceholderStamp();

        public static PlaceholderStamp singleton() {
            return SINGLETON;
        }

        private PlaceholderStamp() {
            super(null, false, false, false, false);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "PlaceholderStamp";
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static class Placeholder
    extends FloatingGuardedNode {
        public static final NodeClass<Placeholder> TYPE = NodeClass.create(Placeholder.class);
        @Node.Input
        ValueNode object;

        public ValueNode object() {
            return this.object;
        }

        protected Placeholder(NodeClass<? extends Placeholder> c, ValueNode object) {
            super(c, PlaceholderStamp.SINGLETON, null);
            this.object = object;
        }

        public Placeholder(ValueNode object) {
            this(TYPE, object);
        }

        public void makeReplacement(Stamp snippetReplaceeStamp) {
            ValueNode value = this.graph().addOrUnique(PiNode.create(this.object(), snippetReplaceeStamp, null));
            this.replaceAndDelete(value);
        }
    }
}

