/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.DeoptimizingFixedWithNextNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, cyclesRationale="read", size=NodeSize.SIZE_1)
public final class SafepointNode
extends DeoptimizingFixedWithNextNode
implements Lowerable,
LIRLowerable,
Simplifiable {
    public static final NodeClass<SafepointNode> TYPE = NodeClass.create(SafepointNode.class);
    @Node.OptionalInput(value=InputType.Association)
    protected AbstractBeginNode loop;

    public SafepointNode() {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
    }

    public SafepointNode(LoopBeginNode loop) {
        super((NodeClass<? extends DeoptimizingFixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.loop = loop;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.visitSafepointNode(this);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.next() instanceof SafepointNode) {
            this.graph().removeFixed(this);
        }
        if (this.loop != null && !(this.loop instanceof LoopBeginNode)) {
            this.graph().removeFixed(this);
        }
    }

    public void setLoop(AbstractBeginNode loop) {
        this.updateUsagesInterface(this.loop, loop);
        this.loop = loop;
    }

    public AbstractBeginNode getLoop() {
        return this.loop;
    }
}

