/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Iterator;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeStack;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.graph.spi.NodeWithIdentity;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNodeInterface;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.spi.NodeValueMap;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo
public abstract class ValueNode
extends Node
implements ValueNodeInterface {
    public static final NodeClass<ValueNode> TYPE = NodeClass.create(ValueNode.class);
    public static final ValueNode[] EMPTY_ARRAY = new ValueNode[0];
    protected Stamp stamp;
    private static final NodePredicate IS_CONSTANT = new NodePredicate(){

        @Override
        public boolean apply(Node n) {
            return n instanceof ConstantNode;
        }
    };

    public ValueNode(NodeClass<? extends ValueNode> c, Stamp stamp) {
        super(c);
        this.stamp = stamp;
    }

    public final Stamp stamp(NodeView view) {
        return view.stamp(this);
    }

    public final void setStamp(Stamp stamp) {
        this.stamp = stamp;
        assert (!this.isAlive() || !this.inferStamp()) : "setStamp called on a node that overrides inferStamp: " + String.valueOf(this);
    }

    @Override
    public final StructuredGraph graph() {
        return (StructuredGraph)super.graph();
    }

    protected final boolean updateStamp(Stamp newStamp) {
        if (newStamp == null || newStamp.equals(this.stamp)) {
            return false;
        }
        this.stamp = newStamp;
        return true;
    }

    public boolean inferStamp() {
        return false;
    }

    public final JavaKind getStackKind() {
        return this.stamp(NodeView.DEFAULT).getStackKind();
    }

    public final boolean isConstant() {
        return this instanceof ConstantNode;
    }

    public static NodePredicate isConstantPredicate() {
        return IS_CONSTANT;
    }

    public final boolean isNullConstant() {
        JavaConstant value = this.asJavaConstant();
        return value != null && value.isNull();
    }

    public final boolean isDefaultConstant() {
        Constant value = this.asConstant();
        return value != null && value.isDefaultForKind();
    }

    public final Constant asConstant() {
        if (this instanceof ConstantNode) {
            return ((ConstantNode)this).getValue();
        }
        return null;
    }

    public boolean isIllegalConstant() {
        return this.isConstant() && this.asConstant().equals((Object)JavaConstant.forIllegal());
    }

    public final boolean isJavaConstant() {
        return this.isConstant() && this.asConstant() instanceof JavaConstant;
    }

    public final JavaConstant asJavaConstant() {
        Constant value = this.asConstant();
        if (value instanceof JavaConstant) {
            return (JavaConstant)value;
        }
        return null;
    }

    @Override
    public final ValueNode asNode() {
        return this;
    }

    protected void updateUsagesInterface(ValueNodeInterface oldInput, ValueNodeInterface newInput) {
        this.updateUsages(oldInput == null ? null : oldInput.asNode(), newInput == null ? null : newInput.asNode());
    }

    @Override
    public boolean isAllowedUsageType(InputType type) {
        if (this.getStackKind() != JavaKind.Void && type == InputType.Value) {
            return true;
        }
        return super.isAllowedUsageType(type);
    }

    public boolean hasUsagesOtherThan(ValueNode node, NodeValueMap nodeValueMap) {
        for (Node usage : this.usages()) {
            if (usage == node || !(usage instanceof ValueNode) || !nodeValueMap.hasOperand(usage)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean checkReplaceAtUsagesInvariants(Node other) {
        assert (other == null || other instanceof ValueNode) : Assertions.errorMessage(this, other);
        if (this.hasUsages() && !this.stamp(NodeView.DEFAULT).isEmpty() && !(other instanceof PhiNode) && other != null) {
            Stamp thisStamp = this.stamp(NodeView.DEFAULT);
            Stamp otherStamp = ((ValueNode)other).stamp(NodeView.DEFAULT);
            assert (thisStamp.isCompatible(otherStamp)) : "stamp have to be compatible";
            boolean morePrecise = otherStamp.join(thisStamp).equals(otherStamp);
            assert (morePrecise) : "stamp can only get more precise " + this.toString(Verbosity.All) + " " + other.toString(Verbosity.All);
        }
        return true;
    }

    public boolean recursivelyDataFlowEqualsUpTo(FloatingNode that, InputType ignoredInputType) {
        if (this == that) {
            return true;
        }
        if (that == null || !ValueNode.recursiveDataFlowEqualsHelper(this, that)) {
            return false;
        }
        NodeBitMap visited = new NodeBitMap(this.graph());
        NodeStack these = new NodeStack();
        NodeStack those = new NodeStack();
        these.push(this);
        those.push(that);
        while (!these.isEmpty()) {
            assert (!those.isEmpty());
            Node thisNode = these.pop();
            Node thatNode = those.pop();
            if (visited.isMarked(thisNode)) continue;
            visited.mark(thisNode);
            Iterator<Position> theseInputs = thisNode.inputPositions().iterator();
            Iterator<Position> thoseInputs = thatNode.inputPositions().iterator();
            while (theseInputs.hasNext() && thoseInputs.hasNext()) {
                Node thatInput;
                Node thisInput;
                Position thisPos = theseInputs.next();
                Position thatPos = thoseInputs.next();
                if (thisPos.getIndex() != thatPos.getIndex() || thisPos.getSubIndex() != thatPos.getSubIndex()) {
                    return false;
                }
                assert (thisPos.getInputType() == thatPos.getInputType()) : String.valueOf((Object)thisPos.getInputType()) + "!=" + String.valueOf((Object)thatPos.getInputType()) + Assertions.errorMessageContext(" thisNode", thisNode, "thatNode", thatNode);
                if (thisPos.getInputType() == ignoredInputType || (thisInput = thisPos.get(thisNode)) == (thatInput = thatPos.get(thatNode))) continue;
                if (thisInput == null || thatInput == null || !ValueNode.recursiveDataFlowEqualsHelper(thisInput, thatInput)) {
                    return false;
                }
                these.push(thisInput);
                those.push(thatInput);
            }
            if (!theseInputs.hasNext() && !thoseInputs.hasNext()) continue;
            return false;
        }
        return true;
    }

    private static boolean recursiveDataFlowEqualsHelper(Node thisNode, Node thatNode) {
        MemoryAccess access;
        GraalError.guarantee(thisNode != thatNode, "identity should be checked by the caller");
        if (thisNode == null || thatNode == null || thisNode.getNodeClass() != thatNode.getNodeClass()) {
            return false;
        }
        if (!(thisNode instanceof FloatingNode) || thisNode instanceof NodeWithIdentity) {
            return false;
        }
        if (!thisNode.valueEquals(thatNode)) {
            return false;
        }
        return !(thisNode instanceof MemoryAccess) || !(access = (MemoryAccess)((Object)thisNode)).getLocationIdentity().isAny() && !access.getLocationIdentity().isMutable();
    }
}

