/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import java.util.Map;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.graal.compiler.util.CollectionsUtil;

@NodeInfo(nameTemplate="Phi({i#values}, {p#valueDescription})")
public class ValuePhiNode
extends PhiNode {
    public static final NodeClass<ValuePhiNode> TYPE = NodeClass.create(ValuePhiNode.class);
    @Node.Input(value=InputType.Value)
    protected NodeInputList<ValueNode> values;

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge) {
        this((NodeClass<? extends ValuePhiNode>)TYPE, stamp, merge);
    }

    protected ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid()) : Assertions.errorMessage(c, stamp, merge);
        this.values = new NodeInputList(this);
    }

    public ValuePhiNode(Stamp stamp, AbstractMergeNode merge, ValueNode ... values) {
        this(TYPE, stamp, merge, values);
    }

    public ValuePhiNode(NodeClass<? extends ValuePhiNode> c, Stamp stamp, AbstractMergeNode merge, ValueNode ... values) {
        super(c, stamp, merge);
        assert (stamp != StampFactory.forVoid()) : Assertions.errorMessage(c, stamp, merge);
        this.values = new NodeInputList((Node)this, (Node[])values);
    }

    @Override
    public InputType valueInputType() {
        return InputType.Value;
    }

    @Override
    public NodeInputList<ValueNode> values() {
        return this.values;
    }

    @Override
    public boolean inferStamp() {
        Stamp valuesStamp = StampTool.meetOrNull(this.values(), this);
        if (valuesStamp == null) {
            valuesStamp = this.stamp;
        }
        if (this.stamp.isCompatible(valuesStamp = this.tryInferLoopPhiStamp(valuesStamp))) {
            valuesStamp = this.stamp.join(valuesStamp);
        }
        return this.updateStamp(valuesStamp);
    }

    private Stamp tryInferLoopPhiStamp(Stamp valuesStamp) {
        if (this.isAlive() && this.isLoopPhi() && valuesStamp.isPointerStamp()) {
            Stamp firstValueStamp = ValuePhiNode.stripProxies(this.firstValue()).stamp(NodeView.DEFAULT);
            if (firstValueStamp.meet(valuesStamp).equals(firstValueStamp)) {
                return valuesStamp;
            }
            boolean hasDirectPhiInput = false;
            for (ValueNode value : this.values()) {
                if (!(ValuePhiNode.stripProxies(value) instanceof ValuePhiNode)) continue;
                hasDirectPhiInput = true;
                break;
            }
            if (!hasDirectPhiInput) {
                return valuesStamp;
            }
            Stamp currentStamp = firstValueStamp;
            NodeFlood flood = new NodeFlood(this.graph());
            flood.addAll(this.values());
            for (Node node : flood) {
                ValueNode value;
                Node unproxifiedNode = ValuePhiNode.stripProxies(node);
                if (unproxifiedNode == this) continue;
                if (unproxifiedNode instanceof ValuePhiNode) {
                    ValuePhiNode phi = (ValuePhiNode)unproxifiedNode;
                    flood.addAll(phi.values());
                    continue;
                }
                if (!(unproxifiedNode instanceof ValueNode) || !(currentStamp = currentStamp.meet((value = (ValueNode)unproxifiedNode).stamp(NodeView.DEFAULT))).equals(valuesStamp)) continue;
                return valuesStamp;
            }
            if (!currentStamp.equals(valuesStamp) && currentStamp.meet(valuesStamp).equals(valuesStamp)) {
                return currentStamp;
            }
        }
        return valuesStamp;
    }

    private static Node stripProxies(Node n) {
        if (n instanceof ValueNode) {
            ValueNode value = (ValueNode)n;
            return ValuePhiNode.stripProxies(value);
        }
        return n;
    }

    private static ValueNode stripProxies(ValueNode v) {
        LimitedValueProxy proxy;
        ValueNode result = v;
        while (result instanceof LimitedValueProxy && (proxy = (LimitedValueProxy)((Object)result)).getOriginalNode().stamp(NodeView.DEFAULT).equals(result.stamp(NodeView.DEFAULT))) {
            result = proxy.getOriginalNode();
        }
        return result;
    }

    @Override
    public boolean verifyNode() {
        Stamp s = null;
        for (ValueNode input : this.values()) {
            assert (input != null);
            if (s == null) {
                s = input.stamp(NodeView.DEFAULT);
                continue;
            }
            if (s.isCompatible(input.stamp(NodeView.DEFAULT))) continue;
            this.fail("Phi Input Stamps are not compatible. Phi:%s inputs:%s", this, CollectionsUtil.mapAndJoin(this.values(), x -> x.toString() + ":" + String.valueOf(x.stamp(NodeView.DEFAULT)), ", "));
        }
        return super.verifyNode();
    }

    @Override
    protected String valueDescription() {
        return this.stamp(NodeView.DEFAULT).unrestricted().toString();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> properties = super.getDebugProperties(map);
        properties.put("valueDescription", this.valueDescription());
        return properties;
    }

    @Override
    public PhiNode duplicateOn(AbstractMergeNode newMerge) {
        return this.graph().addWithoutUnique(new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge));
    }

    @Override
    public ValuePhiNode duplicateWithValues(AbstractMergeNode newMerge, ValueNode ... newValues) {
        return new ValuePhiNode(this.stamp(NodeView.DEFAULT), newMerge, newValues);
    }

    @Override
    public ProxyNode createProxyFor(LoopExitNode lex) {
        return this.graph().addWithoutUnique(new ValueProxyNode(this, lex));
    }
}

