/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.ValueProxy;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(nameTemplate="ValueProxy({i#value})")
public final class ValueProxyNode
extends ProxyNode
implements Canonicalizable,
Virtualizable,
ValueProxy {
    public static final NodeClass<ValueProxyNode> TYPE = NodeClass.create(ValueProxyNode.class);
    @Node.Input
    ValueNode value;

    public ValueProxyNode(ValueNode value, LoopExitNode loopExit) {
        super(TYPE, value.stamp(NodeView.DEFAULT), loopExit);
        this.value = value;
    }

    public ValueProxyNode(Stamp stamp, ValueNode value, LoopExitNode loopExit) {
        super(TYPE, stamp, loopExit);
        this.value = value;
    }

    @Override
    public ValueNode value() {
        return this.value;
    }

    @Override
    public PhiNode createPhi(AbstractMergeNode merge) {
        return this.graph().addWithoutUnique(new ValuePhiNode(this.stamp(NodeView.DEFAULT).unrestricted(), merge));
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.value.stamp(NodeView.DEFAULT));
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        Node result = super.canonical(tool);
        if (result != this) {
            return result;
        }
        ValueNode curValue = this.value;
        if (curValue.getNodeClass().isLeafNode()) {
            return curValue;
        }
        return this;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.value);
        if (alias instanceof VirtualObjectNode) {
            tool.replaceWithVirtual((VirtualObjectNode)alias);
        }
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.value();
    }

    @Override
    public GuardingNode getGuard() {
        return this.proxyPoint();
    }

    @Override
    public ProxyNode duplicateOn(LoopExitNode newProxyPoint, ValueNode newOriginalNode) {
        return this.graph().addWithoutUnique(new ValueProxyNode(newOriginalNode, newProxyPoint));
    }
}

