/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.NarrowableArithmeticNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.UnaryArithmeticNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.CodeUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public final class AbsNode
extends UnaryArithmeticNode<ArithmeticOpTable.UnaryOp.Abs>
implements ArithmeticLIRLowerable,
NarrowableArithmeticNode {
    public static final NodeClass<AbsNode> TYPE = NodeClass.create(AbsNode.class);

    public AbsNode(ValueNode x) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getAbs(), x);
    }

    public static ValueNode create(ValueNode value, NodeView view) {
        ValueNode synonym = AbsNode.findSynonym(value, view);
        if (synonym != null) {
            return synonym;
        }
        return new AbsNode(value);
    }

    protected static ValueNode findSynonym(ValueNode forValue, NodeView view) {
        ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Abs> absOp = ArithmeticOpTable.forStamp(forValue.stamp(view)).getAbs();
        ValueNode synonym = UnaryArithmeticNode.findSynonym(forValue, absOp);
        if (synonym != null) {
            return synonym;
        }
        if (forValue instanceof AbsNode) {
            return forValue;
        }
        if (forValue.stamp(view) instanceof IntegerStamp && ((IntegerStamp)forValue.stamp(view)).isPositive()) {
            return forValue;
        }
        if (forValue instanceof NegateNode) {
            NegateNode negate = (NegateNode)forValue;
            return AbsNode.create(negate.getValue(), view);
        }
        return null;
    }

    @Override
    protected ArithmeticOpTable.UnaryOp<ArithmeticOpTable.UnaryOp.Abs> getOp(ArithmeticOpTable table) {
        return table.getAbs();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        ValueNode synonym = AbsNode.findSynonym(forValue, NodeView.from(tool));
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (NarrowableArithmeticNode.super.isNarrowable(resultBits)) {
            IntegerStamp inputStamp = (IntegerStamp)this.getValue().stamp(NodeView.DEFAULT);
            return CodeUtil.minValue((int)resultBits) <= inputStamp.lowerBound() && inputStamp.upperBound() <= CodeUtil.maxValue((int)resultBits);
        }
        return false;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitMathAbs(nodeValueMap.operand(this.getValue())));
    }
}

