/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.CompressBitsNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class ExpandBitsNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Expand> {
    public static final NodeClass<ExpandBitsNode> TYPE = NodeClass.create(ExpandBitsNode.class);

    public ExpandBitsNode(ValueNode value, ValueNode mask) {
        super(TYPE, ExpandBitsNode.getArithmeticOpTable(value).getExpand(), value, mask);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Expand> getOp(ArithmeticOpTable table) {
        return table.getExpand();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode value, ValueNode mask) {
        ValueNode ret = super.canonical(tool, value, mask);
        if (ret != this) {
            return ret;
        }
        JavaKind kind = value.getStackKind();
        GraalError.guarantee(kind == JavaKind.Int || kind == JavaKind.Long, "unexpected Java kind %s", (Object)kind);
        if (mask.isConstant()) {
            JavaConstant maskAsConstant = mask.asJavaConstant();
            GraalError.guarantee(!value.isConstant(), "should have been folded in super.canonical");
            if (kind == JavaKind.Int) {
                int maskValue = maskAsConstant.asInt();
                if (maskValue == 0) {
                    return mask;
                }
                if (maskValue == -1) {
                    return value;
                }
            } else {
                long maskValue = maskAsConstant.asLong();
                if (maskValue == 0L) {
                    return mask;
                }
                if (maskValue == -1L) {
                    return value;
                }
            }
        }
        if (value.isConstant() && (kind == JavaKind.Int ? value.asJavaConstant().asInt() == -1 : value.asJavaConstant().asLong() == -1L)) {
            return mask;
        }
        if (mask instanceof LeftShiftNode && ((LeftShiftNode)mask).getX().isConstant()) {
            if (kind == JavaKind.Int) {
                int maskX = ((LeftShiftNode)mask).getX().asJavaConstant().asInt();
                if (maskX == 1) {
                    return LeftShiftNode.create(AndNode.create(value, ConstantNode.forInt(1), NodeView.DEFAULT), ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
                if (maskX == -1) {
                    return LeftShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
            } else {
                long maskX = ((LeftShiftNode)mask).getX().asJavaConstant().asLong();
                if (maskX == 1L) {
                    return LeftShiftNode.create(AndNode.create(value, ConstantNode.forLong(1L), NodeView.DEFAULT), ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
                if (maskX == -1L) {
                    return LeftShiftNode.create(value, ((LeftShiftNode)mask).getY(), NodeView.DEFAULT);
                }
            }
        }
        if (value instanceof CompressBitsNode && ((CompressBitsNode)value).getY() == mask) {
            return AndNode.create(((CompressBitsNode)value).getX(), mask, NodeView.DEFAULT);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool builder, ArithmeticLIRGeneratorTool gen) {
        builder.setResult(this, gen.emitIntegerExpand(builder.operand(this.getX()), builder.operand(this.getY())));
    }
}

