/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AbstractNormalizeCompareNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;

@NodeInfo
public final class IntegerNormalizeCompareNode
extends AbstractNormalizeCompareNode {
    public static final NodeClass<IntegerNormalizeCompareNode> TYPE = NodeClass.create(IntegerNormalizeCompareNode.class);
    protected final boolean unsigned;

    public IntegerNormalizeCompareNode(ValueNode x, ValueNode y, JavaKind kind, boolean unsigned) {
        super(TYPE, kind, x, y);
        this.unsigned = unsigned;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public static ValueNode create(ValueNode x, ValueNode y, boolean unsigned, JavaKind kind, ConstantReflectionProvider constantReflection) {
        ValueNode result = IntegerNormalizeCompareNode.tryConstantFold(x, y, false, unsigned, kind, constantReflection);
        if (result != null) {
            return result;
        }
        return new IntegerNormalizeCompareNode(x, y, kind, unsigned);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode result = IntegerNormalizeCompareNode.tryConstantFold(this.x, this.y, false, this.unsigned, this.stamp(view).getStackKind(), tool.getConstantReflection());
        if (result != null) {
            return result;
        }
        return this;
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs) {
        ValueNode b;
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode valueNode = b = swapInputs ? this.x : this.y;
        if (this.unsigned) {
            return IntegerBelowNode.create(a, b, NodeView.DEFAULT);
        }
        return IntegerLessThanNode.create(a, b, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createLowerComparison(boolean swapInputs, ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        ValueNode b;
        ValueNode a = swapInputs ? this.y : this.x;
        ValueNode valueNode = b = swapInputs ? this.x : this.y;
        if (this.unsigned) {
            return IntegerBelowNode.create(constantReflection, metaAccess, options, smallestCompareWidth, a, b, NodeView.DEFAULT);
        }
        return IntegerLessThanNode.create(constantReflection, metaAccess, options, smallestCompareWidth, a, b, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createEqualComparison() {
        return IntegerEqualsNode.create(this.x, this.y, NodeView.DEFAULT);
    }

    @Override
    public LogicNode createEqualComparison(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, NodeView view) {
        return IntegerEqualsNode.create(constantReflection, metaAccess, options, smallestCompareWidth, this.x, this.y, view);
    }
}

