/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AndNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.RightShiftNode;
import jdk.graal.compiler.nodes.calc.ShiftNode;
import jdk.graal.compiler.nodes.calc.UnsignedRightShiftNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PrimitiveConstant;

@NodeInfo(shortName="<<")
public final class LeftShiftNode
extends ShiftNode<ArithmeticOpTable.ShiftOp.Shl> {
    public static final NodeClass<LeftShiftNode> TYPE = NodeClass.create(LeftShiftNode.class);

    public LeftShiftNode(ValueNode x, ValueNode y) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(x).getShl(), x, y);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> op = ArithmeticOpTable.forStamp(x.stamp(view)).getShl();
        ValueNode value = ShiftNode.canonical(op, stamp = op.foldStamp(x.stamp(view), (IntegerStamp)y.stamp(view)), x, y, view);
        if (value != null) {
            return value;
        }
        return LeftShiftNode.canonical(null, op, stamp, x, y);
    }

    @Override
    protected ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> getOp(ArithmeticOpTable table) {
        return table.getShl();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return LeftShiftNode.canonical(this, (ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl>)this.getArithmeticOp(), this.stamp(NodeView.DEFAULT), forX, forY);
    }

    public boolean tryReplaceWithMulNode() {
        MulNode mul = this.getEquivalentMulNode();
        if (mul != null) {
            this.replaceAtUsages(this.graph().addOrUniqueWithInputs(mul));
            return true;
        }
        return false;
    }

    public MulNode getEquivalentMulNode() {
        Stamp stamp;
        if (this.getY().isConstant() && (stamp = this.stamp(NodeView.DEFAULT)) instanceof IntegerStamp) {
            IntegerStamp xStamp;
            IntegerStamp selfStamp = (IntegerStamp)stamp;
            Constant c = this.getY().asConstant();
            if (c instanceof PrimitiveConstant && ((PrimitiveConstant)c).getJavaKind().isNumericInteger() && (xStamp = (IntegerStamp)this.getX().stamp(NodeView.DEFAULT)).getBits() == selfStamp.getBits()) {
                long i = ((PrimitiveConstant)c).asLong();
                long multiplier = 1L << (int)i;
                return new MulNode(this.getX(), ConstantNode.forIntegerStamp(xStamp, multiplier));
            }
        }
        return null;
    }

    private static ValueNode canonical(LeftShiftNode leftShiftNode, ArithmeticOpTable.ShiftOp<ArithmeticOpTable.ShiftOp.Shl> op, Stamp stamp, ValueNode forX, ValueNode forY) {
        LeftShiftNode self = leftShiftNode;
        if (forY.isConstant()) {
            ShiftNode other;
            int amount;
            int originalAmount = amount = forY.asJavaConstant().asInt();
            int mask = op.getShiftAmountMask(stamp);
            if ((amount &= mask) == 0) {
                return forX;
            }
            if (forX instanceof ShiftNode && (other = (ShiftNode)forX).getY().isConstant()) {
                int otherAmount = other.getY().asJavaConstant().asInt() & mask;
                if (other instanceof LeftShiftNode) {
                    int total = amount + otherAmount;
                    if (total != (total & mask)) {
                        return ConstantNode.forIntegerBits(PrimitiveStamp.getBits(stamp), 0L);
                    }
                    return new LeftShiftNode(other.getX(), ConstantNode.forInt(total));
                }
                if ((other instanceof RightShiftNode || other instanceof UnsignedRightShiftNode) && otherAmount == amount) {
                    if (stamp.getStackKind() == JavaKind.Long) {
                        return new AndNode(other.getX(), ConstantNode.forLong(-1L << amount));
                    }
                    assert (stamp.getStackKind() == JavaKind.Int) : Assertions.errorMessage(leftShiftNode, op, stamp, forX, forY);
                    return new AndNode(other.getX(), ConstantNode.forInt(-1 << amount));
                }
            }
            if (originalAmount != amount) {
                return new LeftShiftNode(forX, ConstantNode.forInt(amount));
            }
        }
        if (self == null) {
            self = new LeftShiftNode(forX, forY);
        }
        return self;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitShl(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

