/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import java.util.Set;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.FloatStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ArithmeticOperation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AbsNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.NotNode;
import jdk.graal.compiler.nodes.calc.SqrtNode;
import jdk.graal.compiler.nodes.calc.UnaryNode;
import jdk.graal.compiler.nodes.spi.ArithmeticLIRLowerable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo
public abstract class UnaryArithmeticNode<OP>
extends UnaryNode
implements ArithmeticOperation,
ArithmeticLIRLowerable {
    public static final NodeClass<UnaryArithmeticNode> TYPE = NodeClass.create(UnaryArithmeticNode.class);

    protected UnaryArithmeticNode(NodeClass<? extends UnaryArithmeticNode<OP>> c, ArithmeticOpTable.UnaryOp<OP> opForStampComputation, ValueNode value) {
        super(c, opForStampComputation.foldStamp(value.stamp(NodeView.DEFAULT)), value);
    }

    protected abstract ArithmeticOpTable.UnaryOp<OP> getOp(ArithmeticOpTable var1);

    protected final ArithmeticOpTable.UnaryOp<OP> getOp(ValueNode forValue) {
        return this.getOp(BinaryArithmeticNode.getArithmeticOpTable(forValue));
    }

    @Override
    public final ArithmeticOpTable.UnaryOp<OP> getArithmeticOp() {
        return this.getOp(this.getValue());
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return this.getOp(this.getValue()).foldStamp(newStamp);
    }

    public static ValueNode unaryIntegerOp(StructuredGraph graph, ValueNode v, NodeView view, ArithmeticOpTable.UnaryOp<?> op) {
        return graph.addOrUniqueWithInputs(UnaryArithmeticNode.unaryIntegerOp(v, view, op));
    }

    public static ValueNode unaryIntegerOp(ValueNode v, NodeView view, ArithmeticOpTable.UnaryOp<?> op) {
        if (IntegerStamp.OPS.getNeg().equals(op)) {
            return NegateNode.create(v, view);
        }
        if (IntegerStamp.OPS.getNot().equals(op)) {
            return NotNode.create(v);
        }
        if (IntegerStamp.OPS.getAbs().equals(op)) {
            return AbsNode.create(v, view);
        }
        if (Set.of(IntegerStamp.OPS.getUnaryOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via UnaryArithmeticNode#unaryIntegerOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a unary operation!", op));
        }
        return null;
    }

    public static ValueNode unaryFloatOp(StructuredGraph graph, ValueNode v, NodeView view, ArithmeticOpTable.UnaryOp<?> op) {
        return graph.addOrUniqueWithInputs(UnaryArithmeticNode.unaryFloatOp(v, view, op));
    }

    public static ValueNode unaryFloatOp(ValueNode v, NodeView view, ArithmeticOpTable.UnaryOp<?> op) {
        if (FloatStamp.OPS.getNeg().equals(op)) {
            return NegateNode.create(v, view);
        }
        if (FloatStamp.OPS.getNot().equals(op)) {
            return NotNode.create(v);
        }
        if (FloatStamp.OPS.getAbs().equals(op)) {
            return AbsNode.create(v, view);
        }
        if (FloatStamp.OPS.getSqrt().equals(op)) {
            return SqrtNode.create(v, view);
        }
        if (Set.of(FloatStamp.OPS.getUnaryOps()).contains(op)) {
            GraalError.unimplemented(String.format("creating %s via UnaryArithmeticNode#unaryFloatOp is not implemented yet", op));
        } else {
            GraalError.shouldNotReachHere(String.format("%s is not a unary operation!", op));
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode synonym = UnaryArithmeticNode.findSynonym(forValue, this.getOp(forValue));
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    protected static <OP> ValueNode findSynonym(ValueNode forValue, ArithmeticOpTable.UnaryOp<OP> op) {
        if (forValue.isConstant()) {
            return ConstantNode.forPrimitive(op.foldStamp(forValue.stamp(NodeView.DEFAULT)), op.foldConstant(forValue.asConstant()));
        }
        return null;
    }
}

