/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.calc;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.MinMaxNode;
import jdk.graal.compiler.nodes.spi.LoweringProvider;

@NodeInfo(shortName="UnsignedMin")
public class UnsignedMinNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.UMin> {
    public static final NodeClass<UnsignedMinNode> TYPE = NodeClass.create(UnsignedMinNode.class);

    protected UnsignedMinNode(ValueNode x, ValueNode y) {
        super(TYPE, UnsignedMinNode.getArithmeticOpTable(x).getUMin(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.UMin> getOp(ArithmeticOpTable table) {
        return table.getUMin();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.UMin> op = ArithmeticOpTable.forStamp(x.stamp(view)).getUMin();
        ConstantNode tryConstantFold = UnsignedMinNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new UnsignedMinNode(x, y).maybeCommuteInputs();
    }

    @Override
    public ValueNode asConditional(LoweringProvider lowerer) {
        if (!this.stamp(NodeView.DEFAULT).isIntegerStamp()) {
            return null;
        }
        LogicNode condition = IntegerBelowNode.create(UnsignedMinNode.maybeExtendForCompare(this.getX(), lowerer, NumUtil.Signedness.UNSIGNED), UnsignedMinNode.maybeExtendForCompare(this.getY(), lowerer, NumUtil.Signedness.UNSIGNED), NodeView.DEFAULT);
        return ConditionalNode.create(condition, this.getX(), this.getY(), NodeView.DEFAULT);
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (!super.isNarrowable(resultBits)) {
            return false;
        }
        return super.isNarrowable(resultBits, NumUtil.Signedness.UNSIGNED);
    }
}

