/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.debug;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.spi.NodeWithIdentity;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, nameTemplate="Blackhole {p#reason}")
public final class BlackholeNode
extends FixedWithNextNode
implements LIRLowerable,
NodeWithIdentity {
    public static final NodeClass<BlackholeNode> TYPE = NodeClass.create(BlackholeNode.class);
    @Node.Input
    ValueNode value;
    String reason;

    public BlackholeNode(ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.value = value;
        this.reason = "";
    }

    public BlackholeNode(ValueNode value, String reason) {
        this(value);
        assert (reason != null);
        this.reason = reason;
    }

    public ValueNode getValue() {
        return this.value;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.getLIRGeneratorTool().emitBlackhole(gen.operand(this.value));
    }
}

