/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.util.List;
import java.util.Map;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.spi.ForeignCallSignature;
import jdk.graal.compiler.core.common.spi.ForeignCallsProvider;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.AbstractMemoryCheckpoint;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(nameTemplate="ForeignCall#{p#descriptorName/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, cyclesRationale="Rough estimation of the call operation itself.", size=NodeSize.SIZE_2, sizeRationale="Rough estimation of the call operation itself.")
@Node.NodeIntrinsicFactory
public class ForeignCallNode
extends AbstractMemoryCheckpoint
implements ForeignCall {
    public static final NodeClass<ForeignCallNode> TYPE = NodeClass.create(ForeignCallNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateDuring;
    protected final ForeignCallDescriptor descriptor;
    protected int bci = -5;
    private boolean validateDeoptFrameStates = true;

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp returnStamp, @Node.InjectedNodeParameter ForeignCallsProvider foreignCalls, ForeignCallSignature signature, ValueNode ... arguments) {
        ForeignCallDescriptor descriptor = foreignCalls.getDescriptor(signature);
        return ForeignCallNode.finishIntrinsification(b, returnStamp, new ForeignCallNode(descriptor, arguments));
    }

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp returnStamp, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        return ForeignCallNode.finishIntrinsification(b, returnStamp, new ForeignCallNode(descriptor, arguments));
    }

    public static boolean finishIntrinsification(GraphBuilderContext b, Stamp returnStamp, ForeignCall node) {
        JavaKind returnKind;
        node.asNode().setStamp(returnStamp);
        GraphBuilderContext nonIntrinsicAncestor = b.getNonIntrinsicAncestor();
        if (nonIntrinsicAncestor != null) {
            node.setBci(nonIntrinsicAncestor.bci());
        }
        if ((returnKind = returnStamp.getStackKind()) == JavaKind.Void) {
            b.add(node.asNode());
        } else {
            b.addPush(returnKind, node.asNode());
        }
        return true;
    }

    public ForeignCallNode(ForeignCallsProvider foreignCalls, ForeignCallSignature signature, ValueNode ... arguments) {
        this(TYPE, foreignCalls.getDescriptor(signature), arguments);
    }

    public ForeignCallNode(ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        this(TYPE, descriptor, arguments);
    }

    public ForeignCallNode(ForeignCallDescriptor descriptor, Stamp stamp, List<ValueNode> arguments) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, stamp);
        this.arguments = new NodeInputList<ValueNode>((Node)this, arguments);
        this.descriptor = descriptor;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + String.valueOf(this);
    }

    protected ForeignCallNode(NodeClass<? extends ForeignCallNode> c, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)c, StampFactory.forKind(JavaKind.fromJavaClass(descriptor.getResultType())));
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + String.valueOf(this);
    }

    @Override
    public boolean hasSideEffect() {
        return this.descriptor.getSideEffect() == ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT;
    }

    @Override
    public ForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (this.hasSideEffect() || x == null);
        super.setStateAfter(x);
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        assert (this.bci == -5 || this.bci == bci) : Assertions.errorMessageContext("this", this, "bci", bci);
        this.bci = bci;
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.descriptor.getName();
        }
        return super.toString(verbosity);
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        debugProperties.put("descriptorName", this.descriptor.getName());
        return debugProperties;
    }

    @Override
    public boolean validateDeoptFrameStates() {
        return this.validateDeoptFrameStates;
    }

    public void setValidateDeoptFrameStates(boolean value) {
        this.validateDeoptFrameStates = value;
    }
}

