/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.UnreachableBeginNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.extended.ForeignCall;
import jdk.graal.compiler.nodes.extended.ForeignCallNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.JavaKind;

@NodeInfo(nameTemplate="ForeignCallWithException#{p#descriptor/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, cyclesRationale="Rough estimation of the call operation itself.", size=NodeSize.SIZE_2, sizeRationale="Rough estimation of the call operation itself.")
@Node.NodeIntrinsicFactory
public class ForeignCallWithExceptionNode
extends WithExceptionNode
implements ForeignCall,
Simplifiable {
    public static final NodeClass<ForeignCallWithExceptionNode> TYPE = NodeClass.create(ForeignCallWithExceptionNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> arguments;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateDuring;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;
    protected final ForeignCallDescriptor descriptor;
    protected int bci = -5;

    public static boolean intrinsify(GraphBuilderContext b, @Node.InjectedNodeParameter Stamp returnStamp, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        return ForeignCallNode.finishIntrinsification(b, returnStamp, new ForeignCallWithExceptionNode(descriptor, arguments));
    }

    public ForeignCallWithExceptionNode(ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        this(TYPE, descriptor, arguments);
    }

    protected ForeignCallWithExceptionNode(NodeClass<? extends ForeignCallWithExceptionNode> c, ForeignCallDescriptor descriptor, ValueNode ... arguments) {
        super((NodeClass<? extends WithExceptionNode>)c, StampFactory.forKind(JavaKind.fromJavaClass(descriptor.getResultType())));
        this.arguments = new NodeInputList((Node)this, (Node[])arguments);
        this.descriptor = descriptor;
        assert (descriptor.getArgumentTypes().length == this.arguments.size()) : "wrong number of arguments to " + String.valueOf(this);
    }

    @Override
    public boolean hasSideEffect() {
        return this.descriptor.getSideEffect() == ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT;
    }

    @Override
    public ForeignCallDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState stateAfter) {
        assert (this.hasSideEffect() || stateAfter == null);
        this.updateUsages(this.stateAfter(), stateAfter);
        this.stateAfter = stateAfter;
    }

    @Override
    public FrameState stateDuring() {
        return this.stateDuring;
    }

    @Override
    public void setStateDuring(FrameState stateDuring) {
        this.updateUsages(this.stateDuring, stateDuring);
        this.stateDuring = stateDuring;
    }

    @Override
    public int bci() {
        return this.bci;
    }

    @Override
    public void setBci(int bci) {
        assert (this.bci == -5 || this.bci == bci) : Assertions.errorMessage("BCI must be unknown or equal", this.bci, bci);
        this.bci = bci;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + String.valueOf(this.descriptor);
        }
        return super.toString(verbosity);
    }

    @Override
    public NodeInputList<ValueNode> getArguments() {
        return this.arguments;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.exceptionEdge instanceof UnreachableBeginNode) {
            FixedNode replacement = this.replaceWithNonThrowing();
            tool.addToWorkList(replacement);
        }
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        ForeignCallNode foreignCall = this.asNode().graph().add(new ForeignCallNode(this.descriptor, this.stamp, this.arguments));
        foreignCall.setStateAfter(this.stateAfter());
        foreignCall.setStateDuring(this.stateDuring());
        AbstractBeginNode nextBegin = this.next;
        AbstractBeginNode oldException = this.exceptionEdge;
        this.graph().replaceSplitWithFixed(this, foreignCall, nextBegin);
        GraphUtil.killCFG(oldException);
        return foreignCall;
    }
}

