/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import java.util.Map;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.code.MemoryBarriers;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Membar#{p#location/s}", allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class MembarNode
extends FixedWithNextNode
implements LIRLowerable,
SingleMemoryKill {
    public static final NodeClass<MembarNode> TYPE = NodeClass.create(MembarNode.class);
    protected final FenceKind fence;
    protected final LocationIdentity location;

    public MembarNode(FenceKind fence) {
        this(fence, LocationIdentity.any());
    }

    public MembarNode(FenceKind fence, LocationIdentity location) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.forVoid());
        this.fence = fence;
        this.location = location;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.location;
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        map.put("barriersString", MemoryBarriers.barriersString((int)this.fence.barriers));
        return super.getDebugProperties(map);
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        generator.getLIRGeneratorTool().emitMembar(this.fence.barriers);
    }

    @Node.NodeIntrinsic
    public static native void memoryBarrier(@Node.ConstantNodeParameter FenceKind var0);

    @Node.NodeIntrinsic
    public static native void memoryBarrier(@Node.ConstantNodeParameter FenceKind var0, @Node.ConstantNodeParameter LocationIdentity var1);

    public static enum FenceKind {
        NONE(0),
        STORE_LOAD(4),
        STORE_STORE(8),
        LOAD_ACQUIRE(3),
        STORE_RELEASE(10),
        ALLOCATION_INIT(8),
        CONSTRUCTOR_FREEZE(8),
        FULL(15);

        private final int barriers;

        private FenceKind(int barriers) {
            this.barriers = barriers;
        }
    }
}

