/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.extended;

import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.UnaryOpLogicNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_4)
public final class ObjectIsArrayNode
extends UnaryOpLogicNode
implements Lowerable {
    public static final NodeClass<ObjectIsArrayNode> TYPE = NodeClass.create(ObjectIsArrayNode.class);

    protected ObjectIsArrayNode(ValueNode object) {
        super(TYPE, object);
    }

    public static LogicNode create(ValueNode forValue) {
        return ObjectIsArrayNode.canonicalized(null, forValue);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        return ObjectIsArrayNode.canonicalized(this, forValue);
    }

    private static LogicNode canonicalized(ObjectIsArrayNode node, ValueNode forValue) {
        TriState triState = ObjectIsArrayNode.doTryFold(forValue.stamp(NodeView.DEFAULT));
        if (triState.isKnown()) {
            return LogicConstantNode.forBoolean(triState.toBoolean());
        }
        return node != null ? node : new ObjectIsArrayNode(forValue);
    }

    @Override
    public Stamp getSucceedingStampForValue(boolean negated) {
        if (negated) {
            return null;
        }
        return ((AbstractObjectStamp)StampFactory.object()).asAlwaysArray();
    }

    @Override
    public TriState tryFold(Stamp valueStamp) {
        return ObjectIsArrayNode.doTryFold(valueStamp);
    }

    private static TriState doTryFold(Stamp valueStamp) {
        if (valueStamp instanceof ObjectStamp) {
            ObjectStamp objectStamp = (ObjectStamp)valueStamp;
            if (objectStamp.isAlwaysArray()) {
                return TriState.TRUE;
            }
            ResolvedJavaType type = StampTool.typeOrNull(objectStamp);
            if (type != null && !type.isJavaLangObject() && !type.isInterface()) {
                assert (!type.isArray()) : "Positive case already covered by isAlwaysArray check above";
                return TriState.get((boolean)type.isArray());
            }
        }
        return TriState.UNKNOWN;
    }
}

