/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ArrayRangeWrite;
import jdk.graal.compiler.nodes.extended.RawStoreNode;
import jdk.graal.compiler.nodes.gc.BarrierSet;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePostWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1ArrayRangePreWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1PostWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1PreWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.G1ReferentFieldReadBarrierNode;
import jdk.graal.compiler.nodes.java.AbstractCompareAndSwapNode;
import jdk.graal.compiler.nodes.java.LoweredAtomicReadAndWriteNode;
import jdk.graal.compiler.nodes.memory.FixedAccessNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.WriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.LocationIdentity;

public class G1BarrierSet
implements BarrierSet {
    private final ResolvedJavaType objectArrayType;
    private final ResolvedJavaField referentField;

    public G1BarrierSet(ResolvedJavaType objectArrayType, ResolvedJavaField referentField) {
        this.objectArrayType = objectArrayType;
        this.referentField = referentField;
    }

    @Override
    public BarrierType readBarrierType(LocationIdentity location, ValueNode address, Stamp loadStamp) {
        return BarrierType.NONE;
    }

    @Override
    public BarrierType writeBarrierType(RawStoreNode store) {
        return store.needsBarrier() ? this.guessReadWriteBarrier(store.object(), store.value()) : BarrierType.NONE;
    }

    @Override
    public BarrierType fieldReadBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        if (field.getJavaKind() == JavaKind.Object && field.equals((Object)this.referentField)) {
            return BarrierType.REFERENCE_GET;
        }
        return BarrierType.NONE;
    }

    @Override
    public BarrierType fieldWriteBarrierType(ResolvedJavaField field, JavaKind storageKind) {
        return storageKind == JavaKind.Object ? BarrierType.FIELD : BarrierType.NONE;
    }

    @Override
    public BarrierType arrayWriteBarrierType(JavaKind storageKind) {
        return storageKind == JavaKind.Object ? BarrierType.ARRAY : BarrierType.NONE;
    }

    @Override
    public BarrierType guessReadWriteBarrier(ValueNode object, ValueNode value) {
        if (value.getStackKind() == JavaKind.Object && object.getStackKind() == JavaKind.Object) {
            ResolvedJavaType type = StampTool.typeOrNull(object);
            if (type != null && type.isArray()) {
                return BarrierType.ARRAY;
            }
            if (type == null || type.isAssignableFrom(this.objectArrayType)) {
                return BarrierType.UNKNOWN;
            }
            return BarrierType.FIELD;
        }
        return BarrierType.NONE;
    }

    @Override
    public boolean hasWriteBarrier() {
        return true;
    }

    @Override
    public boolean hasReadBarrier() {
        return false;
    }

    @Override
    public void addBarriers(FixedAccessNode n) {
        if (n instanceof ReadNode) {
            this.addReadNodeBarriers((ReadNode)n);
        } else if (n instanceof WriteNode) {
            WriteNode write = (WriteNode)n;
            this.addWriteBarriers(write, write.value(), null, true);
        } else if (n instanceof LoweredAtomicReadAndWriteNode) {
            LoweredAtomicReadAndWriteNode atomic = (LoweredAtomicReadAndWriteNode)n;
            this.addWriteBarriers(atomic, atomic.getNewValue(), null, true);
        } else if (n instanceof AbstractCompareAndSwapNode) {
            AbstractCompareAndSwapNode cmpSwap = (AbstractCompareAndSwapNode)n;
            this.addWriteBarriers(cmpSwap, cmpSwap.getNewValue(), cmpSwap.getExpectedValue(), false);
        } else if (n instanceof ArrayRangeWrite) {
            this.addArrayRangeBarriers((ArrayRangeWrite)((Object)n));
        } else {
            GraalError.guarantee(n.getBarrierType() == BarrierType.NONE, "missed a node that requires a GC barrier: %s", n.getClass());
        }
    }

    private void addReadNodeBarriers(ReadNode node) {
        if (node.getBarrierType() == BarrierType.REFERENCE_GET) {
            StructuredGraph graph = node.graph();
            G1ReferentFieldReadBarrierNode barrier = graph.add(new G1ReferentFieldReadBarrierNode(node.getAddress(), this.maybeUncompressExpectedValue(node)));
            graph.addAfterFixed(node, barrier);
        }
    }

    protected ValueNode maybeUncompressExpectedValue(ValueNode value) {
        return value;
    }

    private void addWriteBarriers(FixedAccessNode node, ValueNode writtenValue, ValueNode expectedValue, boolean doLoad) {
        BarrierType barrierType = node.getBarrierType();
        switch (barrierType) {
            case NONE: {
                break;
            }
            case FIELD: 
            case ARRAY: 
            case UNKNOWN: {
                if (!G1BarrierSet.isObjectValue(writtenValue)) break;
                StructuredGraph graph = node.graph();
                boolean init = node.getLocationIdentity().isInit();
                if (!init) {
                    this.addG1PreWriteBarrier(node, node.getAddress(), expectedValue, doLoad, graph);
                }
                if (!this.writeRequiresPostBarrier(node, writtenValue)) break;
                ValueNode object = null;
                if (barrierType == BarrierType.FIELD) {
                    object = node.getAddress().getBase();
                    assert (object != null);
                }
                this.addG1PostWriteBarrier(node, node.getAddress(), writtenValue, object, graph);
                break;
            }
            default: {
                throw new GraalError("unexpected barrier type: " + String.valueOf((Object)barrierType));
            }
        }
    }

    protected boolean writeRequiresPostBarrier(FixedAccessNode node, ValueNode writtenValue) {
        assert (G1BarrierSet.isObjectValue(writtenValue));
        return !StampTool.isPointerAlwaysNull(writtenValue);
    }

    private void addArrayRangeBarriers(ArrayRangeWrite write) {
        if (write.writesObjectArray()) {
            StructuredGraph graph = write.asNode().graph();
            if (!write.isInitialization()) {
                G1ArrayRangePreWriteBarrierNode g1ArrayRangePreWriteBarrier = graph.add(new G1ArrayRangePreWriteBarrierNode(write.getAddress(), write.getLength(), write.getElementStride()));
                graph.addBeforeFixed(write.preBarrierInsertionPosition(), g1ArrayRangePreWriteBarrier);
            }
            if (this.arrayRangeWriteRequiresPostBarrier(write)) {
                G1ArrayRangePostWriteBarrierNode g1ArrayRangePostWriteBarrier = graph.add(new G1ArrayRangePostWriteBarrierNode(write.getAddress(), write.getLength(), write.getElementStride()));
                graph.addAfterFixed(write.postBarrierInsertionPosition(), g1ArrayRangePostWriteBarrier);
            }
        }
    }

    protected boolean arrayRangeWriteRequiresPostBarrier(ArrayRangeWrite write) {
        return true;
    }

    private void addG1PreWriteBarrier(FixedAccessNode node, AddressNode address, ValueNode value, boolean doLoad, StructuredGraph graph) {
        G1PreWriteBarrierNode preBarrier = graph.add(new G1PreWriteBarrierNode(address, this.maybeUncompressExpectedValue(value), doLoad));
        GraalError.guarantee(!node.getUsedAsNullCheck(), "trapping null checks are inserted after write barrier insertion: ", (Object)node);
        node.setStateBefore(null);
        graph.addBeforeFixed(node, preBarrier);
    }

    private void addG1PostWriteBarrier(FixedAccessNode node, AddressNode address, ValueNode value, ValueNode object, StructuredGraph graph) {
        boolean alwaysNull = StampTool.isPointerAlwaysNull(value);
        graph.addAfterFixed(node, graph.add(new G1PostWriteBarrierNode(address, this.maybeUncompressExpectedValue(value), object, alwaysNull)));
    }

    private static boolean isObjectValue(ValueNode value) {
        return value.stamp(NodeView.DEFAULT) instanceof AbstractObjectStamp;
    }

    @Override
    public boolean mayNeedPreWriteBarrier(JavaKind storageKind) {
        return this.arrayWriteBarrierType(storageKind) != BarrierType.NONE;
    }
}

