/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.ObjectWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public class G1PostWriteBarrierNode
extends ObjectWriteBarrierNode
implements LIRLowerable {
    public static final NodeClass<G1PostWriteBarrierNode> TYPE = NodeClass.create(G1PostWriteBarrierNode.class);
    @Node.OptionalInput
    protected ValueNode object;
    protected final boolean alwaysNull;

    public G1PostWriteBarrierNode(AddressNode address, ValueNode value, ValueNode object, boolean alwaysNull) {
        this(TYPE, address, value, object, alwaysNull);
    }

    private G1PostWriteBarrierNode(NodeClass<? extends G1PostWriteBarrierNode> c, AddressNode address, ValueNode value, ValueNode object, boolean alwaysNull) {
        super(c, address, value, object == null);
        this.object = object;
        this.alwaysNull = alwaysNull;
    }

    public boolean alwaysNull() {
        return this.alwaysNull;
    }

    @Override
    public WriteBarrierNode.Kind getKind() {
        return WriteBarrierNode.Kind.POST_BARRIER;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        AllocatableValue base;
        if (this.value.isJavaConstant() && this.value.asJavaConstant().isNull()) {
            return;
        }
        LIRGeneratorTool lirGen = generator.getLIRGeneratorTool();
        if (this.object != null) {
            base = lirGen.asAllocatable(generator.operand(this.object));
        } else {
            Value addr = generator.operand(this.address);
            base = lirGen.newVariable(addr.getValueKind());
            lirGen.emitMove(base, addr);
        }
        boolean nonNull = ((ObjectStamp)this.value.stamp(NodeView.DEFAULT)).nonNull();
        if (base.equals((Object)generator.operand(this.value))) {
            return;
        }
        lirGen.getWriteBarrierSet().emitPostWriteBarrier(lirGen, (Value)base, (Value)lirGen.asAllocatable(generator.operand(this.value)), nonNull);
    }
}

