/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.gc;

import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.LIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.gc.ObjectWriteBarrierNode;
import jdk.graal.compiler.nodes.gc.WriteBarrierNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class G1PreWriteBarrierNode
extends ObjectWriteBarrierNode
implements LIRLowerable {
    public static final NodeClass<G1PreWriteBarrierNode> TYPE = NodeClass.create(G1PreWriteBarrierNode.class);
    @Node.OptionalInput(value=InputType.State)
    private FrameState stateBefore;
    private final boolean doLoad;

    public G1PreWriteBarrierNode(AddressNode address, ValueNode expectedObject, boolean doLoad) {
        super(TYPE, address, expectedObject, true);
        assert (doLoad == (expectedObject == null)) : Assertions.errorMessageContext("adr", address, "expectedO", expectedObject, "doLoad", doLoad);
        this.doLoad = doLoad;
    }

    public ValueNode getExpectedObject() {
        return this.getValue();
    }

    public boolean doLoad() {
        return this.doLoad;
    }

    @Override
    public WriteBarrierNode.Kind getKind() {
        return WriteBarrierNode.Kind.PRE_BARRIER;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        ValueNode expectedObject = this.getExpectedObject();
        if (expectedObject == null || !expectedObject.isJavaConstant() || !expectedObject.asJavaConstant().isNull()) {
            AllocatableValue operand = Value.ILLEGAL;
            boolean nonNull = false;
            LIRGeneratorTool lirGen = generator.getLIRGeneratorTool();
            if (expectedObject != null) {
                operand = lirGen.asAllocatable(generator.operand(expectedObject));
                nonNull = ((ObjectStamp)expectedObject.stamp(NodeView.DEFAULT)).nonNull();
                GraalError.guarantee(expectedObject.stamp(NodeView.DEFAULT) instanceof ObjectStamp, "expecting full size object");
            }
            lirGen.getWriteBarrierSet().emitPreWriteBarrier(lirGen, generator.operand(this.address), operand, nonNull);
        }
    }
}

