/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.DeoptimizingNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public abstract class AllocateWithExceptionNode
extends WithExceptionNode
implements Lowerable,
StateSplit,
DeoptimizingNode.DeoptBefore {
    public static final NodeClass<AllocateWithExceptionNode> TYPE = NodeClass.create(AllocateWithExceptionNode.class);
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateAfter;

    protected AllocateWithExceptionNode(NodeClass<? extends AllocateWithExceptionNode> c, Stamp stamp) {
        super((NodeClass<? extends WithExceptionNode>)c, stamp);
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public void setStateAfter(FrameState x) {
        GraalError.guarantee(x == null || x.isAlive(), "frame state must be in a graph: %s", (Object)x);
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

