/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.DeoptimizeNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.java.AbstractNewArrayNode;
import jdk.graal.compiler.nodes.memory.MemoryAccess;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.virtual.VirtualArrayNode;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
@Node.NodeIntrinsicFactory
public final class ArrayLengthNode
extends FixedWithNextNode
implements Canonicalizable.Unary<ValueNode>,
Lowerable,
Virtualizable,
MemoryAccess,
Simplifiable {
    public static final NodeClass<ArrayLengthNode> TYPE = NodeClass.create(ArrayLengthNode.class);
    @Node.Input
    ValueNode array;

    public ValueNode array() {
        return this.array;
    }

    @Override
    public ValueNode getValue() {
        return this.array;
    }

    public ArrayLengthNode(ValueNode array) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, StampFactory.positiveInt());
        this.array = array;
    }

    @Override
    public LocationIdentity getLocationIdentity() {
        return NamedLocationIdentity.ARRAY_LENGTH_LOCATION;
    }

    public static ValueNode create(ValueNode forValue, ConstantReflectionProvider constantReflection) {
        if (forValue instanceof AbstractNewArrayNode) {
            AbstractNewArrayNode newArray = (AbstractNewArrayNode)forValue;
            return newArray.length();
        }
        ValueNode length = ArrayLengthNode.readArrayLength(forValue, constantReflection);
        if (length != null) {
            return length;
        }
        return new ArrayLengthNode(forValue);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        if (forValue.isNullConstant()) {
            return new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.NullCheckException);
        }
        ValueNode len = ArrayLengthNode.searchForConstantLength(tool.getConstantReflection(), forValue);
        if (len != null) {
            return len;
        }
        return this;
    }

    private static ValueNode searchForConstantLength(ConstantReflectionProvider constantReflection, ValueNode forValue) {
        ValueNode len = GraphUtil.arrayLength(forValue, ArrayLengthProvider.FindLengthMode.SEARCH_ONLY, constantReflection);
        return len != null && len.isConstant() ? len : null;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        ValueNode length;
        ValueNode constantLength = ArrayLengthNode.searchForConstantLength(tool.getConstantReflection(), this.getValue());
        if (constantLength == null && !this.graph().isAfterStage(GraphState.StageFlag.HIGH_TIER_LOWERING)) {
            return;
        }
        ValueNode valueNode = length = constantLength == null ? ArrayLengthNode.readArrayLength(this.getValue(), tool.getConstantReflection()) : constantLength;
        if (tool.allUsagesAvailable() && length != null) {
            StructuredGraph graph = this.graph();
            ValueNode replacement = ArrayLengthNode.maybeAddPositivePi(length, this);
            graph.replaceFixedWithFloating(this, replacement);
        }
    }

    public static ValueNode maybeAddPositivePi(ValueNode length, FixedWithNextNode insertionPosition) {
        ValueNode localLength;
        StructuredGraph graph = insertionPosition.graph();
        ValueNode replacement = localLength = graph.addOrUnique(length);
        if (!localLength.isConstant() && localLength.stamp(NodeView.DEFAULT).canBeImprovedWith(StampFactory.positiveInt())) {
            ValueAnchorNode g = graph.add(new ValueAnchorNode());
            graph.addAfterFixed(insertionPosition, g);
            replacement = graph.addWithoutUnique(new PiNode(localLength, StampFactory.positiveInt(), g));
        }
        return replacement;
    }

    public static ValueNode readArrayLength(ValueNode originalArray, ConstantReflectionProvider constantReflection) {
        return GraphUtil.arrayLength(originalArray, ArrayLengthProvider.FindLengthMode.CANONICALIZE_READ, constantReflection);
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode array) {
        AbstractObjectStamp arrayStamp = (AbstractObjectStamp)array.stamp(NodeView.DEFAULT);
        ValueNode anchoredArray = !arrayStamp.isAlwaysArray() || !arrayStamp.nonNull() ? (ValueNode)b.add(new PiNode(array, (Stamp)arrayStamp.asAlwaysArray().asNonNull(), b.add(new BeginNode()))) : array;
        b.addPush(JavaKind.Int, new ArrayLengthNode(anchoredArray));
        return true;
    }

    @Node.NodeIntrinsic
    public static native int arrayLength(Object var0);

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.array());
        if (alias instanceof VirtualArrayNode) {
            VirtualArrayNode virtualArray = (VirtualArrayNode)alias;
            tool.replaceWithValue(ConstantNode.forInt(virtualArray.entryCount(), this.graph()));
        }
    }
}

