/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.nodes.java.DynamicNewArrayNode;
import jdk.graal.compiler.nodes.java.NewArrayWithExceptionNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class DynamicNewArrayWithExceptionNode
extends AllocateWithExceptionNode
implements Canonicalizable {
    public static final NodeClass<DynamicNewArrayWithExceptionNode> TYPE = NodeClass.create(DynamicNewArrayWithExceptionNode.class);
    @Node.Input
    protected ValueNode length;
    @Node.Input
    ValueNode elementType;
    @Node.OptionalInput
    ValueNode voidClass;

    public DynamicNewArrayWithExceptionNode(ValueNode elementType, ValueNode length) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, StampFactory.objectNonNull());
        this.length = length;
        this.elementType = elementType;
    }

    public static boolean throwsIllegalArgumentException(Class<?> elementType, Class<?> voidClass) {
        return elementType == voidClass;
    }

    public static boolean throwsIllegalArgumentException(ResolvedJavaType elementType) {
        return elementType.getJavaKind() == JavaKind.Void;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type;
        if (this.elementType.isConstant() && (type = tool.getConstantReflection().asJavaType(this.elementType.asConstant())) != null && !DynamicNewArrayWithExceptionNode.throwsIllegalArgumentException(type) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type.getArrayClass())) {
            return new NewArrayWithExceptionNode(type, this.length, true, this.stateBefore, this.stateAfter);
        }
        return this;
    }

    public ValueNode getVoidClass() {
        return this.voidClass;
    }

    public void setVoidClass(ValueNode newVoidClass) {
        this.updateUsages(this.voidClass, newVoidClass);
        this.voidClass = newVoidClass;
    }

    public ValueNode getElementType() {
        return this.elementType;
    }

    public ValueNode length() {
        return this.length;
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        DynamicNewArrayNode newArray = this.graph().add(new DynamicNewArrayNode(this.elementType, this.length, true));
        newArray.setStateBefore(this.stateBefore);
        this.graph().replaceSplitWithFixed(this, newArray, this.next());
        newArray.setNodeSourcePosition(this.getNodeSourcePosition());
        return newArray;
    }
}

