/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.nodes.java.DynamicNewInstanceNode;
import jdk.graal.compiler.nodes.java.NewInstanceWithExceptionNode;
import jdk.graal.compiler.nodes.java.ValidateNewInstanceClassNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class DynamicNewInstanceWithExceptionNode
extends AllocateWithExceptionNode
implements Canonicalizable {
    @Node.Input
    ValueNode clazz;
    public static final NodeClass<DynamicNewInstanceWithExceptionNode> TYPE = NodeClass.create(DynamicNewInstanceWithExceptionNode.class);
    protected boolean fillContents;

    public static void createAndPush(GraphBuilderContext b, ValueNode clazz, boolean validateClass) {
        ResolvedJavaType constantType = DynamicNewInstanceWithExceptionNode.tryConvertToNonDynamic(clazz, b);
        if (constantType != null) {
            b.addPush(JavaKind.Object, new NewInstanceWithExceptionNode(constantType, true));
        } else {
            ValueNode clazzLegal = validateClass ? (ValueNode)b.add(new ValidateNewInstanceClassNode(clazz)) : clazz;
            b.addPush(JavaKind.Object, new DynamicNewInstanceWithExceptionNode(clazzLegal, true));
        }
    }

    public DynamicNewInstanceWithExceptionNode(ValueNode clazz, boolean fillContents) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, StampFactory.objectNonNull());
        this.fillContents = fillContents;
        this.clazz = clazz;
    }

    public ValueNode getInstanceType() {
        return this.clazz;
    }

    static ResolvedJavaType tryConvertToNonDynamic(ValueNode clazz, CoreProviders tool) {
        ResolvedJavaType type;
        if (clazz.isConstant() && (type = tool.getConstantReflection().asJavaType(clazz.asConstant())) != null && !DynamicNewInstanceNode.throwsInstantiationException(type, tool.getMetaAccess()) && tool.getMetaAccessExtensionProvider().canConstantFoldDynamicAllocation(type)) {
            return type;
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ResolvedJavaType type = DynamicNewInstanceWithExceptionNode.tryConvertToNonDynamic(this.clazz, tool);
        if (type != null) {
            return new NewInstanceWithExceptionNode(type, this.fillContents, this.stateBefore, this.stateAfter);
        }
        return this;
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        DynamicNewInstanceNode newInstance = this.graph().add(new DynamicNewInstanceNode(this.clazz, this.fillContents));
        newInstance.setStateBefore(this.stateBefore);
        this.graph().replaceSplitWithFixed(this, newInstance, this.next());
        newInstance.setNodeSourcePosition(this.getNodeSourcePosition());
        return newInstance;
    }
}

