/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.StampPair;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.Verbosity;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.UncheckedInterfaceProvider;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo
public class MethodCallTargetNode
extends CallTargetNode
implements IterableNodeType,
Simplifiable {
    public static final NodeClass<MethodCallTargetNode> TYPE = NodeClass.create(MethodCallTargetNode.class);
    protected JavaTypeProfile typeProfile;

    public MethodCallTargetNode(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, JavaTypeProfile typeProfile) {
        this(TYPE, invokeKind, targetMethod, arguments, returnStamp, typeProfile);
    }

    protected MethodCallTargetNode(NodeClass<? extends MethodCallTargetNode> c, CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] arguments, StampPair returnStamp, JavaTypeProfile typeProfile) {
        super(c, arguments, targetMethod, invokeKind, returnStamp);
        this.typeProfile = typeProfile;
    }

    public ValueNode receiver() {
        return this.isStatic() ? null : (ValueNode)this.arguments().get(0);
    }

    public boolean isStatic() {
        return this.invokeKind() == CallTargetNode.InvokeKind.Static;
    }

    public JavaKind returnKind() {
        return this.targetMethod().getSignature().getReturnKind();
    }

    @Override
    public boolean verifyNode() {
        assert (this.getUsageCount() <= 1) : "call target may only be used by a single invoke";
        for (Node n : this.usages()) {
            this.assertTrue(n instanceof Invoke, "call target can only be used from an invoke (%s)", n);
        }
        if (this.invokeKind().isDirect()) {
            this.assertTrue(this.targetMethod().isConcrete(), "special calls or static calls are only allowed for concrete methods (%s)", this.targetMethod());
        }
        if (this.invokeKind() == CallTargetNode.InvokeKind.Static) {
            this.assertTrue(this.targetMethod().isStatic(), "static calls are only allowed for static methods (%s)", this.targetMethod());
        } else {
            this.assertFalse(this.targetMethod().isStatic(), "static calls are only allowed for non-static methods (%s)", this.targetMethod());
        }
        return super.verifyNode();
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Long) {
            return super.toString(Verbosity.Short) + "(" + String.valueOf(this.targetMethod()) + ")";
        }
        return super.toString(verbosity);
    }

    public static ResolvedJavaMethod findSpecialCallTarget(CallTargetNode.InvokeKind invokeKind, ValueNode receiver, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType) {
        if (invokeKind.isDirect()) {
            return null;
        }
        if (targetMethod.canBeStaticallyBound()) {
            return targetMethod;
        }
        return MethodCallTargetNode.devirtualizeCall(invokeKind, targetMethod, contextType, receiver.graph().getAssumptions(), receiver.stamp(NodeView.DEFAULT));
    }

    public static ResolvedJavaMethod devirtualizeCall(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ResolvedJavaType contextType, Assumptions assumptions, Stamp receiverStamp) {
        TypeReference type = StampTool.typeReferenceOrNull(receiverStamp);
        if (invokeKind == CallTargetNode.InvokeKind.Virtual) {
            TypeReference declaringType = TypeReference.createTrusted(assumptions, targetMethod.getDeclaringClass());
            if (type == null) {
                type = declaringType;
            } else {
                Stamp improvedStamp = receiverStamp.tryImproveWith(StampFactory.object(declaringType));
                if (improvedStamp != null) {
                    type = StampTool.typeReferenceOrNull(improvedStamp);
                }
            }
        }
        if (type != null) {
            ResolvedJavaMethod resolvedMethod = type.getType().resolveConcreteMethod(targetMethod, contextType);
            if (resolvedMethod != null && (resolvedMethod.canBeStaticallyBound() || type.isExact() || type.getType().isArray())) {
                return resolvedMethod;
            }
            Assumptions.AssumptionResult uniqueConcreteMethod = type.getType().findUniqueConcreteMethod(targetMethod);
            if (uniqueConcreteMethod != null && uniqueConcreteMethod.canRecordTo(assumptions)) {
                uniqueConcreteMethod.recordTo(assumptions);
                return (ResolvedJavaMethod)uniqueConcreteMethod.getResult();
            }
        }
        return null;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        ResolvedJavaType contextType;
        if (this.invoke().getContextMethod() == null) {
            assert (this.invoke().stateAfter() != null && BytecodeFrame.isPlaceholderBci((int)this.invoke().stateAfter().bci) || BytecodeFrame.isPlaceholderBci((int)this.invoke().stateDuring().bci));
            return;
        }
        Object object = contextType = this.invoke().stateAfter() == null && this.invoke().stateDuring() == null ? null : this.invoke().getContextType();
        if (this.trySimplifyToSpecial(contextType)) {
            return;
        }
        if (this.invokeKind.isInterface()) {
            MethodCallTargetNode result = MethodCallTargetNode.tryDevirtualizeInterfaceCall(this.receiver(), this.targetMethod, this.typeProfile, this.graph().getAssumptions(), contextType, this, this.invoke().asFixedNode());
            assert (result == this) : Assertions.errorMessage(result, this);
        }
    }

    private boolean trySimplifyToSpecial(ResolvedJavaType contextType) {
        ResolvedJavaMethod specialCallTarget = MethodCallTargetNode.findSpecialCallTarget(this.invokeKind, this.receiver(), this.targetMethod, contextType);
        if (specialCallTarget != null) {
            this.setTargetMethod(specialCallTarget);
            this.setInvokeKind(CallTargetNode.InvokeKind.Special);
            return true;
        }
        return false;
    }

    public static MethodCallTargetNode tryDevirtualizeInterfaceCall(ValueNode receiver, ResolvedJavaMethod targetMethod, JavaTypeProfile profile, Assumptions assumptions, ResolvedJavaType contextType, MethodCallTargetNode callTarget, FixedNode insertionPoint) {
        MethodCallTargetNode callTargetResult;
        TypeReference speculatedType;
        UncheckedInterfaceProvider uncheckedInterfaceProvider;
        Stamp uncheckedStamp;
        TypeReference speculatedType2;
        MethodCallTargetNode callTargetResult2;
        ResolvedJavaType singleImplementor;
        if (assumptions == null) {
            return callTarget;
        }
        ResolvedJavaType referencedReceiverType = callTarget.referencedType();
        if (referencedReceiverType == null) {
            return callTarget;
        }
        ResolvedJavaType declaredReceiverType = targetMethod.getDeclaringClass();
        if (declaredReceiverType.isInterface() && (singleImplementor = referencedReceiverType.getSingleImplementor()) != null && !singleImplementor.equals((Object)declaredReceiverType) && (callTargetResult2 = MethodCallTargetNode.tryCheckCastSingleImplementor(receiver, targetMethod, profile, contextType, speculatedType2 = TypeReference.createTrusted(assumptions, singleImplementor), insertionPoint, callTarget)) != null) {
            return callTargetResult2;
        }
        if (receiver instanceof UncheckedInterfaceProvider && (uncheckedStamp = (uncheckedInterfaceProvider = (UncheckedInterfaceProvider)((Object)receiver)).uncheckedStamp()) != null && (speculatedType = StampTool.typeReferenceOrNull(uncheckedStamp)) != null && referencedReceiverType.isAssignableFrom(speculatedType.getType()) && (callTargetResult = MethodCallTargetNode.tryCheckCastSingleImplementor(receiver, targetMethod, profile, contextType, speculatedType, insertionPoint, callTarget)) != null) {
            return callTargetResult;
        }
        callTarget.trySimplifyToSpecial(contextType);
        return callTarget;
    }

    private static MethodCallTargetNode tryCheckCastSingleImplementor(ValueNode receiver, ResolvedJavaMethod targetMethod, JavaTypeProfile profile, ResolvedJavaType contextType, TypeReference speculatedType, FixedNode insertionPoint, MethodCallTargetNode callTarget) {
        ResolvedJavaMethod singleImplementorMethod;
        ResolvedJavaType singleImplementor = speculatedType.getType();
        if (singleImplementor != null && (singleImplementorMethod = singleImplementor.resolveConcreteMethod(targetMethod, contextType)) != null) {
            StructuredGraph graph = insertionPoint.graph();
            AbstractBeginNode anchor = profile != null ? BeginNode.prevBegin(insertionPoint) : null;
            LogicNode condition = graph.addOrUniqueWithInputs(InstanceOfNode.create(speculatedType, receiver, profile, anchor));
            FixedGuardNode guard = graph.add(new FixedGuardNode(condition, DeoptimizationReason.OptimizedTypeCheckViolated, DeoptimizationAction.InvalidateRecompile, false));
            graph.addBeforeFixed(insertionPoint, guard);
            CallTargetNode.InvokeKind invokeKind = speculatedType.isExact() ? CallTargetNode.InvokeKind.Special : CallTargetNode.InvokeKind.Virtual;
            MethodCallTargetNode callTargetResult = callTarget;
            ValueNode valueNode = graph.addOrUnique(new PiNode(receiver, (Stamp)StampFactory.objectNonNull(speculatedType), guard));
            if (callTarget.isAlive()) {
                callTarget.arguments().set(0, (Object)valueNode);
                callTargetResult.setInvokeKind(invokeKind);
                callTargetResult.setTargetMethod(singleImplementorMethod);
            } else {
                ValueNode[] arguments = callTarget.arguments().toArray((A[])new ValueNode[callTarget.arguments().size()]);
                arguments[0] = valueNode;
                callTargetResult = new MethodCallTargetNode(invokeKind, singleImplementorMethod, arguments, callTarget.returnStamp, profile);
            }
            callTargetResult.trySimplifyToSpecial(contextType);
            return callTargetResult;
        }
        return null;
    }

    public JavaTypeProfile getTypeProfile() {
        return this.typeProfile;
    }

    @Override
    public String targetName() {
        if (this.targetMethod() == null) {
            return "??Invalid!";
        }
        return this.targetMethod().format("%h.%n");
    }

    public static MethodCallTargetNode find(StructuredGraph graph, ResolvedJavaMethod method) {
        for (MethodCallTargetNode target : graph.getNodes(TYPE)) {
            if (!target.targetMethod().equals((Object)method)) continue;
            return target;
        }
        return null;
    }

    public void setJavaTypeProfile(JavaTypeProfile profile) {
        this.typeProfile = profile;
    }
}

