/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.IterableNodeType;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.MonitorExit;
import jdk.graal.compiler.nodes.java.AccessMonitorNode;
import jdk.graal.compiler.nodes.java.MonitorIdNode;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.Lowerable;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_64, size=NodeSize.SIZE_64)
public final class MonitorExitNode
extends AccessMonitorNode
implements Virtualizable,
Lowerable,
IterableNodeType,
MonitorExit,
SingleMemoryKill {
    public static final NodeClass<MonitorExitNode> TYPE = NodeClass.create(MonitorExitNode.class);
    @Node.OptionalInput
    ValueNode escapedReturnValue;

    public MonitorExitNode(ValueNode object, MonitorIdNode monitorId, ValueNode escapedValue) {
        super(TYPE, object, monitorId);
        this.escapedReturnValue = escapedValue;
    }

    public void clearEscapedValue() {
        this.updateUsages(this.escapedReturnValue, null);
        this.escapedReturnValue = null;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        VirtualObjectNode virtual;
        if (!tool.getPlatformConfigurationProvider().areLocksSideEffectFree()) {
            return;
        }
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode && (virtual = (VirtualObjectNode)alias).hasIdentity()) {
            MonitorIdNode removedLock = tool.removeLock(virtual);
            GraalError.guarantee(MonitorIdNode.monitorIdentityEquals(removedLock, this.getMonitorId()), "mismatch at %s: %s vs. %s", (Object)this, (Object)removedLock, (Object)this.getMonitorId());
            tool.delete();
        }
    }
}

