/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.graal.compiler.nodes.java.NewInstanceNode;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(nameTemplate="New {p#instanceClass/s}", cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class NewInstanceWithExceptionNode
extends AllocateWithExceptionNode {
    public static final NodeClass<NewInstanceWithExceptionNode> TYPE = NodeClass.create(NewInstanceWithExceptionNode.class);
    protected final ResolvedJavaType instanceClass;
    protected boolean fillContents;

    public NewInstanceWithExceptionNode(ResolvedJavaType type, boolean fillContents) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.instanceClass = type;
        this.fillContents = fillContents;
    }

    public NewInstanceWithExceptionNode(ResolvedJavaType type, boolean fillContents, FrameState stateBefore, FrameState stateAfter) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.instanceClass = type;
        this.fillContents = fillContents;
        this.stateBefore = stateBefore;
        this.stateAfter = stateAfter;
    }

    public ResolvedJavaType instanceClass() {
        return this.instanceClass;
    }

    @Override
    public FixedNode replaceWithNonThrowing() {
        this.killExceptionEdge();
        NewInstanceNode newInstance = this.graph().add(new NewInstanceNode(this.instanceClass, this.fillContents, this.stateBefore));
        this.graph().replaceSplitWithFixed(this, newInstance, this.next());
        newInstance.setNodeSourcePosition(this.getNodeSourcePosition());
        return newInstance;
    }
}

