/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.java;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeList;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.java.AllocateWithExceptionNode;
import jdk.vm.ci.meta.ResolvedJavaType;

@NodeInfo(cycles=NodeCycles.CYCLES_8, cyclesRationale="tlab alloc + header init", size=NodeSize.SIZE_8)
public class NewMultiArrayWithExceptionNode
extends AllocateWithExceptionNode {
    public static final NodeClass<NewMultiArrayWithExceptionNode> TYPE = NodeClass.create(NewMultiArrayWithExceptionNode.class);
    @Node.Input
    protected NodeInputList<ValueNode> dimensions;
    protected final ResolvedJavaType type;

    public NewMultiArrayWithExceptionNode(ResolvedJavaType type, NodeList<ValueNode> dimensions) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.type = type;
        this.dimensions = new NodeInputList<ValueNode>((Node)this, dimensions);
        assert (NumUtil.assertPositiveInt(dimensions.count()));
        assert (type.isArray());
    }

    public NewMultiArrayWithExceptionNode(ResolvedJavaType type, ValueNode[] dimensions) {
        super((NodeClass<? extends AllocateWithExceptionNode>)TYPE, (Stamp)StampFactory.objectNonNull(TypeReference.createExactTrusted(type)));
        this.type = type;
        this.dimensions = new NodeInputList((Node)this, (Node[])dimensions);
        assert (NumUtil.assertPositiveInt(dimensions.length));
        assert (type.isArray());
    }

    public ValueNode dimension(int index) {
        return (ValueNode)this.dimensions.get(index);
    }

    public int dimensionCount() {
        return this.dimensions.size();
    }

    public NodeList<ValueNode> dimensions() {
        return this.dimensions;
    }

    public ResolvedJavaType type() {
        return this.type;
    }
}

