/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.loop.BasicInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedConvertedInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedScaledInductionVariable;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.MathUtil;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import jdk.graal.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;

public class DerivedOffsetInductionVariable
extends DerivedInductionVariable {
    protected final ValueNode offset;
    protected final BinaryArithmeticNode<?> value;

    public DerivedOffsetInductionVariable(LoopEx loop, InductionVariable base, ValueNode offset, BinaryArithmeticNode<?> value) {
        super(loop, base);
        this.offset = offset;
        this.value = value;
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    @Override
    public InductionVariable.Direction direction() {
        InductionVariable.Direction baseDirection = this.base.direction();
        if (baseDirection == null) {
            return null;
        }
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return baseDirection.opposite();
        }
        return baseDirection;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public boolean isConstantInit() {
        try {
            if (this.offset.isConstant() && this.base.isConstantInit()) {
                this.constantInitSafe();
                return true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isConstantStride() {
        return this.base.isConstantStride();
    }

    @Override
    public long constantInit() {
        return this.constantInitSafe();
    }

    private long constantInitSafe() throws ArithmeticException {
        return this.opSafe(this.base.constantInit(), this.offset.asJavaConstant().asLong());
    }

    @Override
    public long constantStride() {
        return this.constantStrideSafe();
    }

    private long constantStrideSafe() throws ArithmeticException {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return LoopUtility.multiplyExact(IntegerStamp.getBits(this.offset.stamp(NodeView.DEFAULT)), this.base.constantStride(), -1L);
        }
        return this.base.constantStride();
    }

    @Override
    public boolean isConstantExtremum() {
        try {
            if (this.offset.isConstant() && this.base.isConstantExtremum()) {
                this.constantExtremumSafe();
                return true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public long constantExtremum() {
        return this.constantExtremumSafe();
    }

    private long constantExtremumSafe() throws ArithmeticException {
        return this.opSafe(this.base.constantExtremum(), this.offset.asJavaConstant().asLong());
    }

    @Override
    public ValueNode initNode() {
        return this.op(this.base.initNode(), this.offset);
    }

    @Override
    public ValueNode strideNode() {
        if (this.value instanceof SubNode && this.base.valueNode() == this.value.getY()) {
            return this.graph().addOrUniqueWithInputs(NegateNode.create(this.base.strideNode(), NodeView.DEFAULT));
        }
        return this.base.strideNode();
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        return this.op(this.base.extremumNode(assumeLoopEntered, stamp), IntegerConvertNode.convert(this.offset, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp, ValueNode maxTripCount) {
        return this.op(this.base.extremumNode(assumeLoopEntered, stamp, maxTripCount), IntegerConvertNode.convert(this.offset, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode exitValueNode() {
        return this.op(this.base.exitValueNode(), this.offset);
    }

    private long opSafe(long b, long o) throws ArithmeticException {
        if (this.value instanceof AddNode) {
            return LoopUtility.addExact(IntegerStamp.getBits(this.offset.stamp(NodeView.DEFAULT)), b, o);
        }
        if (this.value instanceof SubNode) {
            BasicInductionVariable basic;
            InductionVariable inductionVariable;
            if (this.base.valueNode() == this.value.getX()) {
                return LoopUtility.subtractExact(IntegerStamp.getBits(this.offset.stamp(NodeView.DEFAULT)), b, o);
            }
            assert (this.base.valueNode() == this.value.getY() || (inductionVariable = this.base) instanceof BasicInductionVariable && (basic = (BasicInductionVariable)inductionVariable).getOp() instanceof IntegerExactArithmeticNode) : Assertions.errorMessage(this.base, this.base.valueNode(), this.value, this.value.getY());
            return LoopUtility.subtractExact(IntegerStamp.getBits(this.offset.stamp(NodeView.DEFAULT)), b, o);
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.value);
    }

    public ValueNode op(ValueNode b, ValueNode o) {
        return this.op(b, o, true);
    }

    public ValueNode op(ValueNode b, ValueNode o, boolean gvn) {
        if (this.value instanceof AddNode) {
            return MathUtil.add(this.graph(), b, o, gvn);
        }
        if (this.value instanceof SubNode) {
            BasicInductionVariable basic;
            InductionVariable inductionVariable;
            if (this.base.valueNode() == this.value.getX()) {
                return MathUtil.sub(this.graph(), b, o, gvn);
            }
            assert (this.base.valueNode() == this.value.getY() || (inductionVariable = this.base) instanceof BasicInductionVariable && (basic = (BasicInductionVariable)inductionVariable).getOp() instanceof IntegerExactArithmeticNode) : Assertions.errorMessage(this.base, this.base.valueNode(), this.value, this.value.getY());
            return MathUtil.sub(this.graph(), o, b, gvn);
        }
        throw GraalError.shouldNotReachHereUnexpectedValue(this.value);
    }

    @Override
    public void deleteUnusedNodes() {
    }

    @Override
    public boolean isConstantScale(InductionVariable ref) {
        return super.isConstantScale(ref) || this.base.isConstantScale(ref);
    }

    @Override
    public long constantScale(InductionVariable ref) {
        assert (this.isConstantScale(ref));
        if (this == ref) {
            return 1L;
        }
        return this.base.constantScale(ref) * (long)(this.value instanceof SubNode && this.base.valueNode() == this.value.getY() ? -1 : 1);
    }

    @Override
    public boolean offsetIsZero(InductionVariable ref) {
        return this == ref;
    }

    @Override
    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        if (!this.base.offsetIsZero(ref)) {
            return null;
        }
        return this.offset;
    }

    @Override
    public String toString(InductionVariable.IVToStringVerbosity verbosity) {
        if (verbosity == InductionVariable.IVToStringVerbosity.FULL) {
            return String.format("DerivedOffsetInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.offset);
        }
        return String.format("(%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.offset);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase) {
        return this.copyValue(newBase, true);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase, boolean gvn) {
        return this.op(newBase.valueNode(), this.offset, gvn);
    }

    @Override
    public InductionVariable copy(InductionVariable newBase, ValueNode newValue) {
        if (newValue instanceof BinaryArithmeticNode) {
            return new DerivedOffsetInductionVariable(this.loop, newBase, this.offset, (BinaryArithmeticNode)newValue);
        }
        if (newValue instanceof NegateNode) {
            return new DerivedScaledInductionVariable(this.loop, newBase, (NegateNode)newValue);
        }
        assert (newValue instanceof IntegerConvertNode) : "Expected integer convert operation. New baseIV=" + String.valueOf(newBase) + " newValue=" + String.valueOf(newValue);
        return new DerivedConvertedInductionVariable(this.loop, newBase, newValue.stamp(NodeView.DEFAULT), newValue);
    }

    @Override
    public ValueNode entryTripValue() {
        return this.op(this.getBase().entryTripValue(), this.offset);
    }
}

