/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.LinkedList;
import jdk.graal.compiler.core.common.calc.Condition;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.type.ArithmeticOpTable;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.iterators.NodePredicate;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.FullInfopointNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.LeftShiftNode;
import jdk.graal.compiler.nodes.calc.MulNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.NegateNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.debug.ControlFlowAnchored;
import jdk.graal.compiler.nodes.debug.NeverStripMineNode;
import jdk.graal.compiler.nodes.debug.NeverWriteSinkNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.loop.BasicInductionVariable;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.DerivedConvertedInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedOffsetInductionVariable;
import jdk.graal.compiler.nodes.loop.DerivedScaledInductionVariable;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopFragment;
import jdk.graal.compiler.nodes.loop.LoopFragmentInside;
import jdk.graal.compiler.nodes.loop.LoopFragmentInsideBefore;
import jdk.graal.compiler.nodes.loop.LoopFragmentInsideFrom;
import jdk.graal.compiler.nodes.loop.LoopFragmentWhole;
import jdk.graal.compiler.nodes.loop.LoopsData;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.common.util.LoopUtility;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class LoopEx {
    protected final Loop<HIRBlock> loop;
    protected LoopFragmentInside inside;
    protected LoopFragmentWhole whole;
    protected CountedLoopInfo counted;
    protected LoopsData data;
    protected EconomicMap<Node, InductionVariable> ivs;
    protected boolean countedLoopChecked;
    protected int size = -1;

    protected LoopEx(Loop<HIRBlock> loop, LoopsData data) {
        this.loop = loop;
        this.data = data;
    }

    public double localLoopFrequency() {
        return this.data.getCFG().localLoopFrequency(this.loopBegin());
    }

    public ProfileData.ProfileSource localFrequencySource() {
        return this.data.getCFG().localLoopFrequencySource(this.loopBegin());
    }

    public Loop<HIRBlock> loop() {
        return this.loop;
    }

    public LoopFragmentInside inside() {
        if (this.inside == null) {
            this.inside = new LoopFragmentInside(this);
        }
        return this.inside;
    }

    public LoopFragmentWhole whole() {
        if (this.whole == null) {
            this.whole = new LoopFragmentWhole(this);
        }
        return this.whole;
    }

    public void invalidateFragments() {
        this.inside = null;
        this.whole = null;
    }

    public void invalidateFragmentsAndIVs() {
        this.inside = null;
        this.whole = null;
        this.ivs = null;
    }

    public LoopFragmentInsideFrom insideFrom(FixedNode point) {
        GraalError.unimplemented("intentional");
        return null;
    }

    public LoopFragmentInsideBefore insideBefore(FixedNode point) {
        GraalError.unimplemented("intentional");
        return null;
    }

    public boolean isOutsideLoop(Node n) {
        return !this.whole().contains(n);
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loop().getHeader().getBeginNode();
    }

    public FixedNode predecessor() {
        return (FixedNode)this.loopBegin().forwardEnd().predecessor();
    }

    public FixedNode entryPoint() {
        return this.loopBegin().forwardEnd();
    }

    public boolean isCounted() {
        assert (this.countedLoopChecked);
        return this.counted != null;
    }

    public CountedLoopInfo counted() {
        assert (this.countedLoopChecked);
        return this.counted;
    }

    public LoopEx parent() {
        if (this.loop.getParent() == null) {
            return null;
        }
        return this.data.loop(this.loop.getParent());
    }

    public int size() {
        if (this.size == -1) {
            this.size = this.whole().nodes().count();
        }
        return this.size;
    }

    public void resetCounted() {
        assert (this.countedLoopChecked);
        this.ivs = null;
        this.counted = null;
        this.countedLoopChecked = false;
    }

    public String toString() {
        return (String)(this.countedLoopChecked && this.isCounted() ? "CountedLoop [" + String.valueOf(this.counted()) + "] " : "Loop ") + "(depth=" + this.loop().getDepth() + ") " + String.valueOf(this.loopBegin());
    }

    public boolean reassociateInvariants() {
        int count = 0;
        StructuredGraph graph = this.loopBegin().graph();
        InvariantPredicate invariant = new InvariantPredicate();
        NodeBitMap newLoopNodes = graph.createNodeBitMap();
        for (BinaryArithmeticNode binary : this.whole().nodes().filter(BinaryArithmeticNode.class)) {
            if (!binary.mayReassociate()) continue;
            ValueNode result = BinaryArithmeticNode.reassociateMatchedValues(binary, invariant, binary.getX(), binary.getY(), NodeView.DEFAULT);
            if (result == binary) {
                result = BinaryArithmeticNode.reassociateUnmatchedValues(binary, invariant, NodeView.DEFAULT);
            }
            if (result == binary) continue;
            if (!result.isAlive()) {
                assert (!result.isDeleted());
                result = graph.addOrUniqueWithInputs(result);
                newLoopNodes.markAndGrow(result);
                for (Node input : result.inputs()) {
                    if (!this.whole().nodes().isNew(input) || invariant.apply(input)) continue;
                    newLoopNodes.markAndGrow(input);
                }
            }
            binary.replaceAtUsages(result);
            graph.getOptimizationLog().report(LoopEx.class, "InvariantReassociation", binary);
            GraphUtil.killWithUnusedFloatingInputs(binary);
            ++count;
        }
        if (newLoopNodes.isNotEmpty()) {
            this.whole().nodes().union(newLoopNodes);
        }
        return count != 0;
    }

    public boolean detectCounted() {
        if (this.countedLoopChecked) {
            return this.isCounted();
        }
        this.countedLoopChecked = true;
        LoopBeginNode loopBegin = this.loopBegin();
        if (loopBegin.countedLoopDisabled()) {
            return false;
        }
        FixedNode next = loopBegin.next();
        while (next instanceof FixedGuardNode || next instanceof ValueAnchorNode || next instanceof FullInfopointNode) {
            next = ((FixedWithNextNode)next).next();
        }
        if (next instanceof IfNode) {
            LogicNode ifTest;
            IfNode ifNode = (IfNode)next;
            boolean negated = false;
            if (!this.isCfgLoopExit(ifNode.falseSuccessor())) {
                if (!this.isCfgLoopExit(ifNode.trueSuccessor())) {
                    return false;
                }
                negated = true;
            }
            if (!((ifTest = ifNode.condition()) instanceof CompareNode)) {
                return false;
            }
            CompareNode compare = (CompareNode)ifTest;
            Condition condition = null;
            InductionVariable iv = null;
            ValueNode limit = null;
            if (this.isOutsideLoop(compare.getX())) {
                iv = (InductionVariable)this.getInductionVariables().get((Object)compare.getY());
                if (iv != null) {
                    condition = compare.condition().asCondition().mirror();
                    limit = compare.getX();
                }
            } else if (this.isOutsideLoop(compare.getY()) && (iv = (InductionVariable)this.getInductionVariables().get((Object)compare.getX())) != null) {
                condition = compare.condition().asCondition();
                limit = compare.getY();
            }
            if (condition == null) {
                return false;
            }
            if (negated) {
                condition = condition.negate();
            }
            boolean isLimitIncluded = false;
            boolean unsigned = false;
            switch (condition) {
                case EQ: {
                    if (iv.initNode() == limit) {
                        isLimitIncluded = true;
                        break;
                    }
                    return false;
                }
                case NE: {
                    IntegerStamp initStamp = (IntegerStamp)iv.initNode().stamp(NodeView.DEFAULT);
                    IntegerStamp limitStamp = (IntegerStamp)limit.stamp(NodeView.DEFAULT);
                    IntegerStamp counterStamp = (IntegerStamp)iv.valueNode().stamp(NodeView.DEFAULT);
                    if (iv.direction() == InductionVariable.Direction.Up) {
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.upperBound()) break;
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.unsignedUpperBound() && IntegerStamp.sameSign(initStamp, limitStamp)) {
                            unsigned = true;
                            break;
                        }
                        if (iv.isConstantStride() && LoopEx.absStrideIsOne(iv) && initStamp.upperBound() <= limitStamp.lowerBound()) break;
                        return false;
                    }
                    if (iv.direction() == InductionVariable.Direction.Down) {
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.lowerBound()) break;
                        if (limitStamp.asConstant() != null && limitStamp.asConstant().asLong() == counterStamp.unsignedLowerBound() && IntegerStamp.sameSign(initStamp, limitStamp)) {
                            unsigned = true;
                            break;
                        }
                        if (iv.isConstantStride() && LoopEx.absStrideIsOne(iv) && initStamp.lowerBound() >= limitStamp.upperBound()) break;
                        return false;
                    }
                    return false;
                }
                case BE: {
                    unsigned = true;
                }
                case LE: {
                    isLimitIncluded = true;
                    if (iv.direction() == InductionVariable.Direction.Up) break;
                    return false;
                }
                case BT: {
                    unsigned = true;
                }
                case LT: {
                    if (iv.direction() == InductionVariable.Direction.Up) break;
                    return false;
                }
                case AE: {
                    unsigned = true;
                }
                case GE: {
                    isLimitIncluded = true;
                    if (iv.direction() == InductionVariable.Direction.Down) break;
                    return false;
                }
                case AT: {
                    unsigned = true;
                }
                case GT: {
                    if (iv.direction() == InductionVariable.Direction.Down) break;
                    return false;
                }
                default: {
                    throw GraalError.shouldNotReachHere(condition.toString());
                }
            }
            this.counted = new CountedLoopInfo(this, iv, ifNode, limit, isLimitIncluded, negated ? ifNode.falseSuccessor() : ifNode.trueSuccessor(), unsigned);
            return true;
        }
        return false;
    }

    public static boolean absStrideIsOne(InductionVariable limitCheckedIV) {
        return Math.abs(limitCheckedIV.constantStride()) == 1L;
    }

    public boolean isCfgLoopExit(AbstractBeginNode begin) {
        HIRBlock block = this.data.getCFG().blockFor(begin);
        return this.loop.getDepth() > block.getLoopDepth() || this.loop.isNaturalExit(block);
    }

    public LoopsData loopsData() {
        return this.data;
    }

    public void nodesInLoopBranch(NodeBitMap branchNodes, AbstractBeginNode branch) {
        EconomicSet blocks = EconomicSet.create();
        LinkedList<AbstractBeginNode> exits = new LinkedList<AbstractBeginNode>();
        LinkedList<HIRBlock> work = new LinkedList<HIRBlock>();
        ControlFlowGraph cfg = this.loopsData().getCFG();
        NodeBitMap visited = cfg.graph.createNodeBitMap();
        HIRBlock firstSuccBlock = cfg.blockFor(branch);
        work.add(firstSuccBlock);
        while (!work.isEmpty()) {
            HIRBlock b = (HIRBlock)work.remove();
            if (this.loop().isLoopExit(b)) {
                assert (!exits.contains(b.getBeginNode()));
                exits.add(b.getBeginNode());
                continue;
            }
            if (!blocks.add((Object)b.getBeginNode())) continue;
            for (HIRBlock d = (HIRBlock)b.getDominatedSibling(); d != null; d = (HIRBlock)d.getDominatedSibling()) {
                if (!this.loop.getBlocks().contains(d) || firstSuccBlock.getPostdominator() == d || visited.isMarked(d.getBeginNode())) continue;
                visited.mark(d.getBeginNode());
                work.add(d);
            }
        }
        LoopFragment.computeNodes(branchNodes, branch.graph(), this, (Iterable<AbstractBeginNode>)blocks, exits);
    }

    public EconomicMap<Node, InductionVariable> getInductionVariables() {
        if (this.ivs == null) {
            this.ivs = this.findInductionVariables();
        }
        return this.ivs;
    }

    private EconomicMap<Node, InductionVariable> findInductionVariables() {
        EconomicMap currentIvs = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        LinkedList<InductionVariable> scanQueue = new LinkedList<InductionVariable>();
        LoopBeginNode loopBegin = this.loopBegin();
        EndNode forwardEnd = loopBegin.forwardEnd();
        for (PhiNode phiNode : loopBegin.valuePhis()) {
            ValueNode stride;
            ValueNode backValue = phiNode.singleBackValueOrThis();
            if (backValue == phiNode || (stride = LoopEx.calcOffsetTo(this, backValue, phiNode, false)) == null) continue;
            BasicInductionVariable biv = new BasicInductionVariable(this, (ValuePhiNode)phiNode, phiNode.valueAt(forwardEnd), stride, (BinaryArithmeticNode)backValue);
            currentIvs.put((Object)phiNode, (Object)biv);
            scanQueue.add(biv);
        }
        while (!scanQueue.isEmpty()) {
            InductionVariable baseIv = (InductionVariable)scanQueue.remove();
            ValueNode valueNode = baseIv.valueNode();
            for (ValueNode op : valueNode.usages().filter(ValueNode.class)) {
                if (this.isOutsideLoop(op) || op.hasExactlyOneUsage() && op.usages().first() == valueNode) continue;
                DerivedInductionVariable iv = null;
                ValueNode offset = LoopEx.calcOffsetTo(this, op, valueNode, true);
                if (offset != null) {
                    iv = new DerivedOffsetInductionVariable(this, baseIv, offset, (BinaryArithmeticNode)op);
                } else if (op instanceof NegateNode) {
                    iv = new DerivedScaledInductionVariable(this, baseIv, (NegateNode)op);
                } else {
                    ValueNode scale = LoopEx.calcScaleTo(this, op, valueNode);
                    if (scale != null) {
                        iv = new DerivedScaledInductionVariable(this, baseIv, scale, op);
                    } else {
                        boolean isValidConvert;
                        boolean bl = isValidConvert = op instanceof PiNode || op instanceof SignExtendNode;
                        if (!isValidConvert && op instanceof ZeroExtendNode) {
                            ZeroExtendNode zeroExtendNode = (ZeroExtendNode)op;
                            isValidConvert = ((IntegerStamp)zeroExtendNode.stamp(NodeView.DEFAULT)).isPositive();
                        }
                        if (!isValidConvert && op instanceof NarrowNode) {
                            NarrowNode narrow = (NarrowNode)op;
                            isValidConvert = narrow.isLossless();
                        }
                        if (isValidConvert) {
                            iv = new DerivedConvertedInductionVariable(this, baseIv, op.stamp(NodeView.DEFAULT), op);
                        }
                    }
                }
                if (iv == null) continue;
                currentIvs.put((Object)op, (Object)iv);
                scanQueue.offer(iv);
            }
        }
        return currentIvs;
    }

    private static ValueNode calcOffsetTo(LoopEx loop, ValueNode opNode, ValueNode base, boolean forDerivedIV) {
        if (LoopUtility.isNumericInteger(opNode) && (opNode instanceof AddNode || opNode instanceof SubNode)) {
            BinaryArithmeticNode arithOp = (BinaryArithmeticNode)opNode;
            ArithmeticOpTable.Op op = arithOp.getArithmeticOp();
            if (arithOp.getX() == base && loop.isOutsideLoop(arithOp.getY())) {
                return arithOp.getY();
            }
            if ((((ArithmeticOpTable.BinaryOp)op).isCommutative() || forDerivedIV) && arithOp.getY() == base && loop.isOutsideLoop(arithOp.getX())) {
                return arithOp.getX();
            }
        }
        return null;
    }

    private static ValueNode calcScaleTo(LoopEx loop, ValueNode op, ValueNode base) {
        LeftShiftNode shift;
        if (op instanceof MulNode) {
            MulNode mul = (MulNode)op;
            if (mul.getX() == base && loop.isOutsideLoop(mul.getY())) {
                return mul.getY();
            }
            if (mul.getY() == base && loop.isOutsideLoop(mul.getX())) {
                return mul.getX();
            }
        }
        if (op instanceof LeftShiftNode && (shift = (LeftShiftNode)op).getX() == base && shift.getY().isConstant()) {
            return ConstantNode.forIntegerStamp(base.stamp(NodeView.DEFAULT), 1 << shift.getY().asJavaConstant().asInt(), base.graph());
        }
        return null;
    }

    public void deleteUnusedNodes() {
        if (this.ivs != null) {
            for (InductionVariable iv : this.ivs.getValues()) {
                iv.deleteUnusedNodes();
            }
        }
    }

    public static boolean canDuplicateLoopNode(Node node) {
        FrameState frameState;
        if (node instanceof ControlFlowAnchored) {
            return false;
        }
        return !(node instanceof FrameState) || !(frameState = (FrameState)node).isExceptionHandlingBCI();
    }

    public static boolean canStripMineLoopNode(Node node) {
        return !(node instanceof NeverStripMineNode);
    }

    public static boolean canWriteSinkLoopNode(Node node) {
        return !(node instanceof NeverWriteSinkNode);
    }

    public boolean canDuplicateLoop() {
        for (Node node : this.inside().nodes()) {
            if (LoopEx.canDuplicateLoopNode(node)) continue;
            return false;
        }
        return true;
    }

    public boolean canStripMine() {
        for (Node node : this.inside().nodes()) {
            if (LoopEx.canStripMineLoopNode(node)) continue;
            return false;
        }
        return true;
    }

    public boolean canWriteSink() {
        for (Node node : this.inside().nodes()) {
            if (LoopEx.canWriteSinkLoopNode(node)) continue;
            return false;
        }
        return true;
    }

    public boolean canBecomeLimitTestAfterFloatingReads(IfNode ifNode) {
        return false;
    }

    private class InvariantPredicate
    implements NodePredicate {
        private final Graph.Mark mark;

        InvariantPredicate() {
            this.mark = LoopEx.this.loopBegin().graph().getMark();
        }

        @Override
        public boolean apply(Node n) {
            if (LoopEx.this.loopBegin().graph().isNew(this.mark, n)) {
                for (Node input : n.inputs()) {
                    if (this.apply(input)) continue;
                    return false;
                }
                return true;
            }
            return LoopEx.this.isOutsideLoop(n);
        }
    }
}

