/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.Position;
import jdk.graal.compiler.graph.iterators.NodeIterable;
import jdk.graal.compiler.loop.phases.LoopTransformations;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.BeginNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardPhiNode;
import jdk.graal.compiler.nodes.GuardProxyNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopEndNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MemoryProxyNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.ProxyNode;
import jdk.graal.compiler.nodes.SafepointNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.ValueProxyNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.CompareNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.IntegerBelowNode;
import jdk.graal.compiler.nodes.calc.SubNode;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.extended.OpaqueNode;
import jdk.graal.compiler.nodes.extended.OpaqueValueNode;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.loop.CountedLoopInfo;
import jdk.graal.compiler.nodes.loop.InductionVariable;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopFragment;
import jdk.graal.compiler.nodes.loop.LoopFragmentWhole;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryPhiNode;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.nodes.util.IntegerHelper;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class LoopFragmentInside
extends LoopFragment {
    private EconomicMap<PhiNode, ValueNode> mergedInitializers;
    private final Graph.DuplicationReplacement dataFixBefore = new Graph.DuplicationReplacement(){

        @Override
        public Node replacement(Node oriInput) {
            if (!(oriInput instanceof ValueNode)) {
                return oriInput;
            }
            return LoopFragmentInside.this.prim((ValueNode)oriInput);
        }
    };
    private final Graph.DuplicationReplacement dataFixWithinAfter = new Graph.DuplicationReplacement(){

        @Override
        public Node replacement(Node oriInput) {
            if (!(oriInput instanceof ValueNode)) {
                return oriInput;
            }
            return LoopFragmentInside.this.primAfter((ValueNode)oriInput);
        }
    };
    private EconomicMap<PhiNode, PhiNode> old2NewPhi;

    public LoopFragmentInside(LoopEx loop) {
        super(loop);
    }

    public LoopFragmentInside(LoopFragmentInside original) {
        super(null, original);
    }

    @Override
    public LoopFragmentInside duplicate() {
        assert (!this.isDuplicate());
        return new LoopFragmentInside(this);
    }

    @Override
    public LoopFragmentInside original() {
        return (LoopFragmentInside)super.original();
    }

    public void appendInside(LoopEx loop) {
        GraalError.unimplemented("intentional");
    }

    @Override
    public LoopEx loop() {
        assert (!this.isDuplicate());
        return super.loop();
    }

    @Override
    public void insertBefore(LoopEx loop) {
        assert (this.isDuplicate());
        assert (this.original().loop() == loop) : "Original loop " + String.valueOf(this.original().loop()) + " != " + String.valueOf(loop);
        this.patchNodes(this.dataFixBefore);
        AbstractBeginNode end = this.mergeEnds();
        this.mergeEarlyExits();
        this.original().patchPeeling(this);
        AbstractBeginNode entry = (AbstractBeginNode)this.getDuplicatedNode(loop.loopBegin());
        loop.entryPoint().replaceAtPredecessor(entry);
        end.setNext(loop.entryPoint());
    }

    public void insertWithinAfter(LoopEx loop, EconomicMap<LoopBeginNode, OpaqueNode> opaqueUnrolledStrides) {
        ValueNode duplicatedNode;
        assert (this.isDuplicate());
        assert (this.original().loop() == loop) : String.valueOf(this.original().loop()) + "!=" + String.valueOf(loop);
        this.patchNodes(this.dataFixWithinAfter);
        LoopBeginNode mainLoopBegin = loop.loopBegin();
        ArrayList<ValueNode> backedgeValues = new ArrayList<ValueNode>();
        EconomicMap new2OldPhis = EconomicMap.create();
        EconomicMap originalPhi2Backedges = EconomicMap.create();
        for (PhiNode phiNode : mainLoopBegin.phis()) {
            originalPhi2Backedges.put((Object)phiNode, (Object)phiNode.valueAt(1));
        }
        for (PhiNode phiNode : mainLoopBegin.phis()) {
            ValueNode valueNode = phiNode.valueAt(1);
            duplicatedNode = (ValueNode)this.getDuplicatedNode(valueNode);
            if (duplicatedNode == null) {
                if (mainLoopBegin.isPhiAtMerge(valueNode)) {
                    duplicatedNode = ((PhiNode)valueNode).valueAt(1);
                } else assert (valueNode.isConstant() || loop.isOutsideLoop(valueNode)) : "Not duplicated node " + String.valueOf(valueNode);
            }
            if (duplicatedNode != null) {
                new2OldPhis.put((Object)duplicatedNode, (Object)valueNode);
            }
            backedgeValues.add(duplicatedNode);
        }
        int index = 0;
        for (PhiNode phiNode : mainLoopBegin.phis()) {
            if ((duplicatedNode = (ValueNode)backedgeValues.get(index++)) == null) continue;
            phiNode.setValueAt(1, duplicatedNode);
        }
        CompareNode compareNode = this.placeNewSegmentAndCleanup(loop, (EconomicMap<Node, Node>)new2OldPhis, (EconomicMap<Node, Node>)originalPhi2Backedges);
        assert (loop.whole().nodes().filter(SafepointNode.class).count() == this.nodes().filter(SafepointNode.class).count() || loop.counted.isInverted()) : "No safepoints left in the original loop or the loop is inverted " + String.valueOf(loop);
        for (SafepointNode safepoint : loop.whole().nodes().filter(SafepointNode.class)) {
            this.graph().removeFixed(safepoint);
        }
        StructuredGraph structuredGraph = mainLoopBegin.graph();
        if (opaqueUnrolledStrides != null) {
            OpaqueNode opaque = (OpaqueNode)opaqueUnrolledStrides.get((Object)loop.loopBegin());
            CountedLoopInfo counted = loop.counted();
            ValueNode counterStride = counted.getLimitCheckedIV().strideNode();
            if (opaque == null || opaque.isDeleted()) {
                ValueNode limit = counted.getLimit();
                opaque = new OpaqueValueNode(AddNode.add(counterStride, counterStride, NodeView.DEFAULT));
                ValueNode newLimit = LoopFragmentInside.partialUnrollOverflowCheck(opaque, limit, counted);
                GraalError.guarantee(compareNode.hasExactlyOneUsage(), "Unrolling loop %s with condition %s, which has multiple usages. Usages other than the loop exit check would get an incorrect condition.", (Object)loop.loopBegin(), (Object)compareNode);
                compareNode.replaceFirstInput(limit, structuredGraph.addOrUniqueWithInputs(newLimit));
                opaqueUnrolledStrides.put((Object)loop.loopBegin(), (Object)opaque);
            } else {
                assert (counted.getLimitCheckedIV().isConstantStride());
                assert (!LoopTransformations.strideAdditionOverflows(loop)) : "Stride addition must not overflow";
                ValueNode previousValue = opaque.getValue();
                opaque.setValue(structuredGraph.addOrUniqueWithInputs(AddNode.add(counterStride, previousValue, NodeView.DEFAULT)));
                GraphUtil.tryKillUnused(previousValue);
            }
        }
        mainLoopBegin.setUnrollFactor(mainLoopBegin.getUnrollFactor() * 2);
        structuredGraph.getDebug().dump(4, (Object)structuredGraph, "LoopPartialUnroll %s", loop);
        mainLoopBegin.getDebug().dump(3, (Object)mainLoopBegin.graph(), "After insertWithinAfter %s", mainLoopBegin);
    }

    public static ValueNode partialUnrollOverflowCheck(OpaqueNode opaque, ValueNode limit, CountedLoopInfo counted) {
        LogicNode overflowCheck;
        ConstantNode extremum;
        int bits = ((IntegerStamp)limit.stamp(NodeView.DEFAULT)).getBits();
        ValueNode newLimit = SubNode.create(limit, opaque, NodeView.DEFAULT);
        IntegerHelper helper = counted.getCounterIntegerHelper();
        if (counted.getDirection() == InductionVariable.Direction.Up) {
            extremum = ConstantNode.forIntegerBits(bits, helper.minValue());
            overflowCheck = IntegerBelowNode.create(SubNode.create(limit, extremum, NodeView.DEFAULT), opaque, NodeView.DEFAULT);
        } else {
            assert (counted.getDirection() == InductionVariable.Direction.Down) : counted.getDirection();
            extremum = ConstantNode.forIntegerBits(bits, helper.maxValue());
            overflowCheck = IntegerBelowNode.create(opaque, SubNode.create(limit, extremum, NodeView.DEFAULT), NodeView.DEFAULT);
        }
        return ConditionalNode.create(overflowCheck, extremum, newLimit, NodeView.DEFAULT);
    }

    protected CompareNode placeNewSegmentAndCleanup(LoopEx loop, EconomicMap<Node, Node> new2OldPhis, EconomicMap<Node, Node> originalPhi2Backedges) {
        CountedLoopInfo mainCounted = loop.counted();
        LoopBeginNode mainLoopBegin = loop.loopBegin();
        StructuredGraph graph = mainLoopBegin.graph();
        IfNode loopTest = mainCounted.getLimitTest();
        IfNode newSegmentLoopTest = (IfNode)this.getDuplicatedNode(loopTest);
        graph.getDebug().dump(4, graph, "After duplicating segment");
        if (mainCounted.getBody() != loop.loopBegin()) {
            Node predecessor = newSegmentLoopTest.predecessor();
            while (predecessor instanceof FixedWithNextNode) {
                FixedWithNextNode fixedPredecessor = (FixedWithNextNode)predecessor;
                for (Node node : fixedPredecessor.usages().snapshot()) {
                    node.replaceFirstInput(fixedPredecessor, loopTest.predecessor());
                }
                predecessor = fixedPredecessor.predecessor();
            }
            AbstractBeginNode falseSuccessor = newSegmentLoopTest.falseSuccessor();
            for (Node node : falseSuccessor.anchored().snapshot()) {
                node.replaceFirstInput(falseSuccessor, loopTest.falseSuccessor());
            }
            AbstractBeginNode trueSuccessor = newSegmentLoopTest.trueSuccessor();
            for (Node usage : trueSuccessor.anchored().snapshot()) {
                usage.replaceFirstInput(trueSuccessor, loopTest.trueSuccessor());
            }
            graph.getDebug().dump(4, graph, "After stitching new segment into control flow after existing one");
            assert (graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL) || mainLoopBegin.loopExits().count() <= 1) : "Can only merge early loop exits if graph has value proxies " + String.valueOf(mainLoopBegin);
            this.mergeEarlyLoopExits(graph, mainLoopBegin, mainCounted, new2OldPhis, loop);
            graph.removeSplitPropagate(newSegmentLoopTest, loopTest.trueSuccessor() == mainCounted.getBody() ? trueSuccessor : falseSuccessor);
            graph.getDebug().dump(4, graph, "Before placing segment");
            if (mainCounted.getBody().next() instanceof LoopEndNode && mainCounted.getLimitTest().predecessor() == mainCounted.loop.loopBegin()) {
                GraphUtil.killCFG((FixedNode)this.getDuplicatedNode(mainLoopBegin));
            } else {
                AbstractBeginNode abstractBeginNode = (AbstractBeginNode)this.getDuplicatedNode(mainLoopBegin);
                FixedNode newSegmentFirstNode = abstractBeginNode.next();
                EndNode newSegmentEnd = LoopFragmentInside.getBlockEnd((FixedNode)this.getDuplicatedNode(mainLoopBegin.loopEnds().first().predecessor()));
                FixedWithNextNode newSegmentLastNode = (FixedWithNextNode)newSegmentEnd.predecessor();
                LoopEndNode loopEndNode = mainLoopBegin.getSingleLoopEnd();
                FixedWithNextNode lastCodeNode = (FixedWithNextNode)loopEndNode.predecessor();
                abstractBeginNode.clearSuccessors();
                if (abstractBeginNode.hasAnchored()) {
                    if (!(lastCodeNode instanceof GuardingNode) || !(lastCodeNode instanceof AnchoringNode)) {
                        ValueAnchorNode newAnchoringPointAfterPrevIteration = graph.add(new ValueAnchorNode());
                        graph.addAfterFixed(lastCodeNode, newAnchoringPointAfterPrevIteration);
                        lastCodeNode = newAnchoringPointAfterPrevIteration;
                    }
                    abstractBeginNode.replaceAtUsages((Node)lastCodeNode, InputType.Guard, InputType.Anchor);
                    assert (abstractBeginNode.usages().filter(x -> !(x instanceof SafepointNode)).count() == 0) : "Must only have safepoint(association) usages left for " + String.valueOf(abstractBeginNode) + " usages=" + String.valueOf(abstractBeginNode.usages());
                    abstractBeginNode.replaceAtUsages((Node)mainLoopBegin, InputType.Association);
                }
                lastCodeNode.replaceFirstSuccessor(loopEndNode, newSegmentFirstNode);
                newSegmentLastNode.replaceFirstSuccessor(newSegmentEnd, loopEndNode);
                abstractBeginNode.safeDelete();
                newSegmentEnd.safeDelete();
            }
            graph.getDebug().dump(4, graph, "After placing segment");
            return (CompareNode)loopTest.condition();
        }
        throw GraalError.shouldNotReachHere("Cannot unroll inverted loop");
    }

    protected void mergeEarlyLoopExits(StructuredGraph graph, LoopBeginNode mainLoopBegin, CountedLoopInfo mainCounted, EconomicMap<Node, Node> new2OldPhis, LoopEx loop) {
        if (mainLoopBegin.loopExits().count() <= 1) {
            return;
        }
        assert (graph.isBeforeStage(GraphState.StageFlag.VALUE_PROXY_REMOVAL)) : "Unrolling with multiple exits requires proxies";
        for (LoopExitNode exit : mainLoopBegin.loopExits().snapshot()) {
            if (exit == mainCounted.getCountedExit()) continue;
            FixedNode next = exit.next();
            AbstractBeginNode begin = (AbstractBeginNode)this.getDuplicatedNode(exit);
            if (next instanceof EndNode) {
                this.mergeRegularEarlyExit(next, begin, exit, mainLoopBegin, graph, new2OldPhis, loop);
                continue;
            }
            GraalError.shouldNotReachHere("Can only unroll loops where the early exits which merge " + String.valueOf(next) + " duplicated node is " + String.valueOf(begin) + " main loop begin is " + String.valueOf(mainLoopBegin));
        }
    }

    private void mergeRegularEarlyExit(FixedNode next, AbstractBeginNode exitBranchBegin, LoopExitNode oldExit, LoopBeginNode mainLoopBegin, StructuredGraph graph, EconomicMap<Node, Node> new2OldPhis, LoopEx loop) {
        AbstractMergeNode merge = ((EndNode)next).merge();
        assert (merge instanceof MergeNode) : "Can only merge loop exits on regular merges";
        assert (exitBranchBegin.next() == null);
        LoopExitNode lex = graph.add(new LoopExitNode(mainLoopBegin));
        this.createExitStateForNewSegmentEarlyExit(graph, oldExit, lex, new2OldPhis);
        EndNode end = graph.add(new EndNode());
        exitBranchBegin.setNext(lex);
        lex.setNext(end);
        merge.addForwardEnd(end);
        for (PhiNode phi : merge.phis()) {
            ValueNode input = phi.valueAt((EndNode)next);
            ValueNode replacement = !loop.whole().contains(input) ? input : LoopFragmentInside.patchProxyAtPhi(phi, lex, this.getNodeInExitPathFromUnrolledSegment((ProxyNode)input, new2OldPhis));
            phi.addInput(replacement);
        }
    }

    public static ValueNode patchProxyAtPhi(PhiNode phi, LoopExitNode lex, ValueNode proxyInput) {
        if (phi instanceof ValuePhiNode) {
            return phi.graph().addOrUnique(new ValueProxyNode(proxyInput, lex));
        }
        if (phi instanceof MemoryPhiNode) {
            return phi.graph().addOrUnique(new MemoryProxyNode((MemoryKill)((Object)proxyInput), lex, ((MemoryPhiNode)phi).getLocationIdentity()));
        }
        if (phi instanceof GuardPhiNode) {
            return phi.graph().addOrUnique(new GuardProxyNode((GuardingNode)((Object)proxyInput), lex));
        }
        throw GraalError.shouldNotReachHere("Unknown phi type " + String.valueOf(phi));
    }

    private void createExitStateForNewSegmentEarlyExit(StructuredGraph graph, final LoopExitNode exit, final LoopExitNode lex, final EconomicMap<Node, Node> new2OldPhis) {
        assert (exit.stateAfter() != null);
        FrameState exitState = exit.stateAfter();
        FrameState duplicate = exitState.duplicateWithVirtualState();
        graph.getDebug().dump(5, graph, "After duplicating state %s for new exit %s", exitState, lex);
        duplicate.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){
            final /* synthetic */ LoopFragmentInside this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void apply(Node from, Position p) {
                ValueNode to = (ValueNode)p.get(from);
                if (to instanceof ProxyNode) {
                    ProxyNode originalProxy = (ProxyNode)to;
                    if (originalProxy.proxyPoint() == exit) {
                        ValueNode replacement = this.this$0.getNodeInExitPathFromUnrolledSegment(originalProxy, (EconomicMap<Node, Node>)new2OldPhis);
                        assert (replacement != null) : originalProxy;
                        p.set(from, originalProxy.duplicateOn(lex, replacement));
                    }
                } else if (this.this$0.original().contains(to)) {
                    ValueNode replacement = (ValueNode)this.this$0.getDuplicatedNode(to);
                    assert (replacement != null);
                    p.set(from, replacement);
                }
            }
        });
        graph.getDebug().dump(5, (Object)graph, "After duplicating state replacing values with inputs proxied %s", duplicate);
        lex.setStateAfter(duplicate);
    }

    private ValueNode getNodeInExitPathFromUnrolledSegment(ProxyNode proxy, EconomicMap<Node, Node> new2OldPhis) {
        ValueNode originalNode = proxy.getOriginalNode();
        ValueNode replacement = null;
        if (this.original().contains(originalNode) || proxy.proxyPoint().loopBegin().isPhiAtMerge(originalNode)) {
            ValueNode nextIterationVal = (ValueNode)this.getDuplicatedNode(originalNode);
            if (nextIterationVal == null) {
                assert (proxy.proxyPoint().loopBegin().isPhiAtMerge(originalNode));
                PhiNode loopPhi = (PhiNode)originalNode;
                LoopBeginNode mainLoopBegin = proxy.proxyPoint().loopBegin();
                LoopEndNode endBeforeSegment = mainLoopBegin.getSingleLoopEnd();
                ValueNode phiInputAtOriginalSegment = loopPhi.valueAt(endBeforeSegment);
                replacement = (ValueNode)new2OldPhis.get((Object)phiInputAtOriginalSegment);
                if (replacement == null) {
                    replacement = phiInputAtOriginalSegment;
                }
                assert (replacement != null);
            } else {
                replacement = nextIterationVal;
            }
        } else {
            replacement = originalNode;
        }
        return replacement;
    }

    protected static EndNode getBlockEnd(FixedNode node) {
        FixedNode curNode = node;
        while (curNode instanceof FixedWithNextNode) {
            curNode = ((FixedWithNextNode)curNode).next();
        }
        return (EndNode)curNode;
    }

    @Override
    public NodeBitMap nodes() {
        if (this.nodes == null) {
            LoopFragmentWhole whole = this.loop().whole();
            whole.nodes();
            this.nodes = whole.nodes.copy();
            LoopBeginNode loopBegin = this.loop().loopBegin();
            for (PhiNode phi : loopBegin.phis()) {
                this.nodes.clear(phi);
            }
            this.clearStateNodes(loopBegin);
            for (LoopExitNode exit : this.exits()) {
                this.clearStateNodes(exit);
                for (ProxyNode proxy : exit.proxies()) {
                    this.nodes.clear(proxy);
                }
            }
        }
        return this.nodes;
    }

    private void clearStateNodes(StateSplit stateSplit) {
        FrameState loopState = stateSplit.stateAfter();
        if (loopState != null) {
            loopState.applyToVirtual(v -> {
                if (v.usages().filter(n -> !this.nodes.isNew(n) && this.nodes.isMarked(n) && n != stateSplit).isEmpty()) {
                    this.nodes.clear(v);
                }
            });
        }
    }

    public NodeIterable<LoopExitNode> exits() {
        return this.loop().loopBegin().loopExits();
    }

    @Override
    protected Graph.DuplicationReplacement getDuplicationReplacement() {
        final LoopBeginNode loopBegin = this.loop().loopBegin();
        final StructuredGraph graph = this.graph();
        return new Graph.DuplicationReplacement(){
            private EconomicMap<Node, Node> seenNode = EconomicMap.create((Equivalence)Equivalence.IDENTITY);

            @Override
            public Node replacement(Node original) {
                try (DebugCloseable position = original.withNodeSourcePosition();){
                    Node value;
                    if (original == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node node = value;
                            return node;
                        }
                        AbstractBeginNode newValue = graph.add(new BeginNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        AbstractBeginNode abstractBeginNode = newValue;
                        return abstractBeginNode;
                    }
                    if (original instanceof LoopExitNode && ((LoopExitNode)original).loopBegin() == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node newValue = value;
                            return newValue;
                        }
                        AbstractBeginNode newValue = graph.add(new BeginNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        AbstractBeginNode abstractBeginNode = newValue;
                        return abstractBeginNode;
                    }
                    if (original instanceof LoopEndNode && ((LoopEndNode)original).loopBegin() == loopBegin) {
                        value = (Node)this.seenNode.get((Object)original);
                        if (value != null) {
                            Node newValue = value;
                            return newValue;
                        }
                        EndNode newValue = graph.add(new EndNode());
                        this.seenNode.put((Object)original, (Object)newValue);
                        EndNode endNode = newValue;
                        return endNode;
                    }
                    Node node = original;
                    return node;
                }
            }
        };
    }

    @Override
    protected void beforeDuplication() {
    }

    public EconomicMap<PhiNode, PhiNode> getOld2NewPhi() {
        return this.old2NewPhi;
    }

    private void patchPeeling(LoopFragmentInside peel) {
        boolean bl;
        LoopBeginNode loopBegin = this.loop().loopBegin();
        LinkedList<PhiNode> newPhis = new LinkedList<PhiNode>();
        NodeBitMap usagesToPatch = this.nodes.copy();
        for (LoopExitNode loopExitNode : this.exits()) {
            LoopFragmentInside.markStateNodes(loopExitNode, usagesToPatch);
            for (ProxyNode proxy : loopExitNode.proxies()) {
                usagesToPatch.markAndGrow(proxy);
            }
        }
        LoopFragmentInside.markStateNodes(loopBegin, usagesToPatch);
        List<PhiNode> oldPhis = loopBegin.phis().snapshot();
        if (peel.old2NewPhi == null) {
            peel.old2NewPhi = EconomicMap.create();
        }
        for (PhiNode phi : oldPhis) {
            ValueNode first;
            if (phi.hasNoUsages()) {
                peel.old2NewPhi.put((Object)phi, null);
                continue;
            }
            if (loopBegin.loopEnds().count() == 1) {
                ValueNode b = phi.valueAt(loopBegin.loopEnds().first());
                if (b == null) {
                    assert (phi instanceof GuardPhiNode) : Assertions.errorMessage(phi);
                    first = null;
                } else {
                    first = peel.prim(b);
                }
            } else {
                first = (ValueNode)peel.mergedInitializers.get((Object)phi);
            }
            PhiNode newPhi = phi.duplicateOn(loopBegin);
            newPhi.setNodeSourcePosition(phi.getNodeSourcePosition());
            peel.old2NewPhi.put((Object)phi, (Object)newPhi);
            newPhi.addInput(first);
            for (LoopEndNode end : loopBegin.orderedLoopEnds()) {
                newPhi.addInput(phi.valueAt(end));
            }
            peel.putDuplicatedNode(phi, newPhi);
            newPhis.add(newPhi);
            for (Node usage : phi.usages().snapshot()) {
                if (!usagesToPatch.isMarkedAndGrow(usage)) continue;
                usage.replaceFirstInput(phi, newPhi);
            }
        }
        for (PhiNode phi : newPhis) {
            for (int i = 0; i < phi.valueCount(); ++i) {
                PhiNode newV;
                ValueNode v = phi.valueAt(i);
                if (!loopBegin.isPhiAtMerge(v) || (newV = (PhiNode)peel.getDuplicatedNode((PhiNode)v)) == null) continue;
                phi.setValueAt(i, (ValueNode)newV);
            }
        }
        boolean bl2 = true;
        while (bl) {
            bl = false;
            int i = 0;
            block8: while (i < oldPhis.size()) {
                PhiNode oldPhi = oldPhis.get(i);
                for (Node usage : oldPhi.usages()) {
                    if (usage instanceof PhiNode && oldPhis.contains(usage)) continue;
                    oldPhis.remove(i);
                    bl = true;
                    continue block8;
                }
                ++i;
            }
        }
        for (PhiNode deadPhi : oldPhis) {
            deadPhi.clearInputs();
        }
        for (PhiNode deadPhi : oldPhis) {
            if (!deadPhi.isAlive()) continue;
            GraphUtil.killWithUnusedFloatingInputs(deadPhi);
        }
    }

    private static void markStateNodes(StateSplit stateSplit, NodeBitMap marks) {
        FrameState exitState = stateSplit.stateAfter();
        if (exitState != null) {
            exitState.applyToVirtual(v -> marks.markAndGrow(v));
        }
    }

    @Override
    protected ValueNode prim(ValueNode b) {
        assert (this.isDuplicate());
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        if (loopBegin.isPhiAtMerge(b)) {
            PhiNode phi = (PhiNode)b;
            return phi.valueAt(loopBegin.forwardEnd());
        }
        if (this.nodesReady) {
            ValueNode v = (ValueNode)this.getDuplicatedNode(b);
            if (v == null) {
                return b;
            }
            return v;
        }
        return b;
    }

    protected ValueNode primAfter(ValueNode b) {
        assert (this.isDuplicate());
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        if (loopBegin.isPhiAtMerge(b)) {
            PhiNode phi = (PhiNode)b;
            assert (phi.valueCount() == 2) : Assertions.errorMessage(phi);
            return phi.valueAt(1);
        }
        if (this.nodesReady) {
            ValueNode v = (ValueNode)this.getDuplicatedNode(b);
            if (v == null) {
                return b;
            }
            return v;
        }
        return b;
    }

    private AbstractBeginNode mergeEnds() {
        AbstractBeginNode newExit;
        assert (this.isDuplicate());
        LinkedList<EndNode> endsToMerge = new LinkedList<EndNode>();
        EconomicMap reverseEnds = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        LoopBeginNode loopBegin = this.original().loop().loopBegin();
        for (LoopEndNode le : loopBegin.loopEnds()) {
            AbstractEndNode duplicate = (AbstractEndNode)this.getDuplicatedNode(le);
            if (duplicate == null) continue;
            endsToMerge.add((EndNode)duplicate);
            reverseEnds.put((Object)duplicate, (Object)le);
        }
        this.mergedInitializers = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        StructuredGraph graph = this.graph();
        if (endsToMerge.size() == 1) {
            AbstractEndNode end = (AbstractEndNode)endsToMerge.get(0);
            assert (end.hasNoUsages());
            try (DebugCloseable position = end.withNodeSourcePosition();){
                newExit = graph.add(new BeginNode());
                end.replaceAtPredecessor(newExit);
                end.safeDelete();
            }
        } else {
            AbstractMergeNode newExitMerge;
            assert (endsToMerge.size() > 1) : endsToMerge;
            newExit = newExitMerge = (AbstractMergeNode)graph.add(new MergeNode());
            FrameState state = loopBegin.stateAfter();
            FrameState duplicateState = null;
            if (state != null) {
                duplicateState = state.duplicateWithVirtualState();
                newExitMerge.setStateAfter(duplicateState);
            }
            for (EndNode end : endsToMerge) {
                newExitMerge.addForwardEnd(end);
            }
            for (final PhiNode phi : loopBegin.phis().snapshot()) {
                if (phi.hasNoUsages()) continue;
                final PhiNode firstPhi = phi.duplicateOn(newExitMerge);
                firstPhi.setNodeSourcePosition(newExitMerge.getNodeSourcePosition());
                for (AbstractEndNode abstractEndNode : newExitMerge.forwardEnds()) {
                    LoopEndNode loopEnd = (LoopEndNode)reverseEnds.get((Object)abstractEndNode);
                    ValueNode prim = this.prim(phi.valueAt(loopEnd));
                    assert (prim != null);
                    firstPhi.addInput(prim);
                }
                PhiNode initializer = firstPhi;
                if (duplicateState != null) {
                    duplicateState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(this){

                        @Override
                        public void apply(Node from, Position p) {
                            if (p.get(from) == phi) {
                                p.set(from, firstPhi);
                            }
                        }
                    });
                }
                this.mergedInitializers.put((Object)phi, (Object)initializer);
            }
        }
        return newExit;
    }
}

