/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.nodes.loop.LoopEx;
import jdk.graal.compiler.nodes.loop.LoopFragment;

public class LoopFragmentWhole
extends LoopFragment {
    public LoopFragmentWhole(LoopEx loop) {
        super(loop);
    }

    public LoopFragmentWhole(LoopFragmentWhole original) {
        super(null, original);
    }

    @Override
    public LoopFragmentWhole duplicate() {
        LoopFragmentWhole loopFragmentWhole = new LoopFragmentWhole(this);
        loopFragmentWhole.reify();
        return loopFragmentWhole;
    }

    private void reify() {
        assert (this.isDuplicate());
        this.patchNodes(null);
        this.mergeEarlyExits();
    }

    @Override
    public NodeBitMap nodes() {
        if (this.nodes == null) {
            Loop<HIRBlock> loop = this.loop().loop();
            NodeBitMap loopNodes = this.graph().createNodeBitMap();
            LoopFragment.computeNodes(loopNodes, this.graph(), this.loop(), LoopFragment.toHirBlocks(loop.getBlocks()), LoopFragment.toHirBlocks(loop.getLoopExits()));
            this.nodes = loopNodes;
        }
        return this.nodes;
    }

    @Override
    protected ValueNode prim(ValueNode b) {
        return (ValueNode)this.getDuplicatedNode(b);
    }

    @Override
    protected Graph.DuplicationReplacement getDuplicationReplacement() {
        final FixedNode entry = this.loop().entryPoint();
        final StructuredGraph graph = this.graph();
        return new Graph.DuplicationReplacement(){
            private EndNode endNode;

            @Override
            public Node replacement(Node o) {
                if (o == entry) {
                    if (this.endNode == null) {
                        this.endNode = graph.add(new EndNode());
                    }
                    return this.endNode;
                }
                return o;
            }
        };
    }

    public FixedNode entryPoint() {
        if (this.isDuplicate()) {
            LoopBeginNode newLoopBegin = (LoopBeginNode)this.getDuplicatedNode(this.original().loop().loopBegin());
            return newLoopBegin.forwardEnd();
        }
        return this.loop().entryPoint();
    }

    @Override
    protected void beforeDuplication() {
    }

    @Override
    public void insertBefore(LoopEx loop) {
    }
}

