/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.loop;

import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

public class LoopSafepointVerification {
    public static final boolean PRINT_SAFEPOINT_NOT_FOUND = false;
    private EconomicMap<Node, SafepointData> safepointVerificationData;

    public boolean verifyLoopSafepoints(StructuredGraph g) {
        if (!g.hasLoops()) {
            return true;
        }
        EconomicMap contexts = EconomicMap.create();
        for (LoopBeginNode lb : g.getNodes(LoopBeginNode.TYPE)) {
            if (!lb.isAlive()) continue;
            LoopContext.getLoopRelations(lb, g, (EconomicMap<LoopBeginNode, LoopContext>)contexts);
        }
        if (this.safepointVerificationData == null) {
            this.safepointVerificationData = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        }
        EconomicSet loopsToVisit = EconomicSet.create();
        EconomicSet originalLoopsInTheGraph = EconomicSet.create();
        for (Node node : this.safepointVerificationData.getKeys()) {
            loopsToVisit.add((Object)((LoopBeginNode)node));
            originalLoopsInTheGraph.add((Object)((LoopBeginNode)node));
        }
        for (LoopBeginNode loopBeginNode : g.getNodes(LoopBeginNode.TYPE)) {
            SafepointData newData = SafepointData.fromLoopBegin(loopBeginNode, ((LoopContext)contexts.get((Object)loopBeginNode)).innerLoopBegins.size(), ((LoopContext)contexts.get((Object)loopBeginNode)).depth);
            if (this.safepointVerificationData.containsKey((Object)loopBeginNode)) {
                assert (loopsToVisit.contains((Object)loopBeginNode));
                loopsToVisit.remove((Object)loopBeginNode);
                assert (((SafepointData)this.safepointVerificationData.get((Object)loopBeginNode)).assertNotWeaker(newData));
            }
            this.safepointVerificationData.put((Object)loopBeginNode, (Object)newData);
        }
        for (LoopBeginNode loopBeginNode : loopsToVisit) {
            assert (loopBeginNode.isDeleted()) : Assertions.errorMessage("This loop must be deleted since it was not found during iteration", loopBeginNode);
            SafepointData sd = (SafepointData)this.safepointVerificationData.removeKey((Object)loopBeginNode);
            if (sd.canHaveSafepoints) continue;
            for (Node n : this.safepointVerificationData.getKeys()) {
                LoopBeginNode other = (LoopBeginNode)n;
                if (originalLoopsInTheGraph.contains((Object)other)) continue;
                SafepointData otherData = (SafepointData)this.safepointVerificationData.get((Object)other);
                assert (otherData != null) : Assertions.errorMessage("Must be in map as map was propagated previously", other);
                assert (other != loopBeginNode) : Assertions.errorMessage("Must be different nodes since one was deleted and the other is in the graph", loopBeginNode, other);
                if (sd.sameStateOrNsp(otherData)) assert (sd.assertNotWeaker(otherData));
            }
        }
        return true;
    }

    static class LoopContext {
        EconomicSet<LoopBeginNode> innerLoopBegins = EconomicSet.create();
        LoopBeginNode lb;
        int depth;

        LoopContext(LoopBeginNode lb) {
            this.lb = lb;
        }

        static void printContexts(EconomicMap<LoopBeginNode, LoopContext> contexts) {
            MapCursor cursor = contexts.getEntries();
            while (cursor.advance()) {
                LoopContext context = (LoopContext)cursor.getValue();
                TTY.printf("Loop %s at depth %s has inner loops %s %n", context.lb, context.depth, context.innerLoopBegins);
            }
        }

        static void getLoopRelations(LoopBeginNode lb, StructuredGraph graph, EconomicMap<LoopBeginNode, LoopContext> contexts) {
            if (!contexts.containsKey((Object)lb)) {
                contexts.put((Object)lb, (Object)new LoopContext(lb));
            }
            EconomicSet innerLoops = EconomicSet.create();
            innerLoops.add((Object)lb);
            int enterSeen = 0;
            FixedNode cur = lb.forwardEnd();
            while (cur != null) {
                if (cur instanceof LoopExitNode) {
                    LoopExitNode lex = (LoopExitNode)cur;
                    innerLoops.add((Object)lex.loopBegin());
                    cur = lex.loopBegin().forwardEnd();
                    continue;
                }
                if (cur instanceof LoopBeginNode) {
                    LoopBeginNode cl = (LoopBeginNode)cur;
                    if (!contexts.containsKey((Object)cl)) {
                        contexts.put((Object)cl, (Object)new LoopContext(cl));
                    }
                    ((LoopContext)contexts.get((Object)cl)).innerLoopBegins.addAll(innerLoops);
                    ++enterSeen;
                }
                if (cur.predecessor() != null) {
                    cur = (FixedNode)cur.predecessor();
                    continue;
                }
                if (cur instanceof AbstractMergeNode) {
                    AbstractMergeNode am = (AbstractMergeNode)cur;
                    cur = am.forwardEndAt(0);
                    continue;
                }
                if (cur != graph.start()) continue;
            }
            ((LoopContext)contexts.get((Object)lb)).depth = enterSeen;
        }
    }

    static class SafepointData {
        boolean canHaveSafepoints;
        LoopBeginNode lb;
        NodeSourcePosition nsp;
        FrameState fs;
        int outerLoops;
        int innerLoops;

        SafepointData() {
        }

        static SafepointData fromLoopBegin(LoopBeginNode lb, int innerLoops, int outerLoops) {
            SafepointData sd = new SafepointData();
            sd.lb = lb;
            sd.canHaveSafepoints = lb.canEndsSafepoint();
            sd.fs = lb.stateAfter();
            sd.nsp = lb.getNodeSourcePosition();
            sd.innerLoops = innerLoops;
            sd.outerLoops = outerLoops;
            return sd;
        }

        boolean assertNotWeaker(SafepointData newData) {
            if (!this.canHaveSafepoints) assert (!newData.canHaveSafepoints) : Assertions.errorMessage("Safepoint verification cannot become weaker", this.lb, "previously the loop had canHaveSafepoints=false but now it has canHaveSafepoints=true", newData.lb);
            return true;
        }

        public boolean sameStateOrNsp(SafepointData otherData) {
            if (otherData.fs == this.fs) {
                return true;
            }
            if (this.nsp != null && otherData.nsp != null && !otherData.nsp.equals(this.nsp)) {
                return false;
            }
            FrameState thisState = this.fs;
            FrameState otherState = otherData.fs;
            if (thisState != null && otherState != null && !thisState.valueEquals(otherState)) {
                return false;
            }
            if (this.innerLoops != otherData.innerLoops) {
                return false;
            }
            if (this.outerLoops != otherData.outerLoops) {
                return false;
            }
            return SafepointData.optimizerRelatedLoops(this.lb, otherData.lb);
        }

        private static boolean optimizerRelatedLoops(LoopBeginNode lb1, LoopBeginNode lb2) {
            boolean isTouchedByStripMining;
            if (lb1.isCompilerInverted() != lb2.isCompilerInverted()) {
                return false;
            }
            boolean bl = isTouchedByStripMining = lb1.isStripMinedInner() || lb1.isStripMinedOuter();
            if (isTouchedByStripMining) {
                if (lb1.isStripMinedInner() != lb2.isStripMinedInner()) {
                    return false;
                }
                if (lb2.isStripMinedOuter() != lb2.isStripMinedOuter()) {
                    return false;
                }
            }
            long cloneFromIdLb1 = lb1.getClonedFromNodeId();
            long cloneFromIdLb2 = lb2.getClonedFromNodeId();
            if (cloneFromIdLb1 != -1L || cloneFromIdLb2 != -1L) {
                assert (lb2.isAlive()) : Assertions.errorMessage("When verifying loops the second one must be alive always", lb1, lb2);
                if (lb1.isDeleted() && cloneFromIdLb2 != -1L) {
                    long lb1IdBeforeDeletion = lb1.getIdBeforeDeletion();
                    return lb1IdBeforeDeletion == cloneFromIdLb2;
                }
                if ((long)lb1.getId() == cloneFromIdLb2) {
                    return true;
                }
                return cloneFromIdLb1 == cloneFromIdLb2;
            }
            return true;
        }
    }
}

