/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.MemoryMap;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.spi.LIRLowerable;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Extension, InputType.Memory}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class MemoryMapNode
extends FloatingNode
implements MemoryMap,
SingleMemoryKill,
LIRLowerable {
    public static final NodeClass<MemoryMapNode> TYPE = NodeClass.create(MemoryMapNode.class);
    protected final List<LocationIdentity> locationIdentities;
    @Node.Input(value=InputType.Memory)
    NodeInputList<ValueNode> nodes;

    private boolean checkOrder(EconomicMap<LocationIdentity, MemoryKill> mmap) {
        for (int i = 0; i < this.locationIdentities.size(); ++i) {
            LocationIdentity locationIdentity = this.locationIdentities.get(i);
            ValueNode n = (ValueNode)this.nodes.get(i);
            this.assertTrue(mmap.get((Object)locationIdentity) == n, "iteration order of keys differs from values in input map", new Object[0]);
        }
        return true;
    }

    public MemoryMapNode(EconomicMap<LocationIdentity, MemoryKill> mmap) {
        super((NodeClass<? extends FloatingNode>)TYPE, StampFactory.forVoid());
        int size = mmap.size();
        this.locationIdentities = new ArrayList<LocationIdentity>(size);
        this.nodes = new NodeInputList((Node)this, size);
        int index = 0;
        MapCursor cursor = mmap.getEntries();
        while (cursor.advance()) {
            this.locationIdentities.add((LocationIdentity)cursor.getKey());
            this.nodes.initialize(index, (ValueNode)cursor.getValue());
            ++index;
        }
        assert (this.checkOrder(mmap));
    }

    public boolean isEmpty() {
        if (this.locationIdentities.isEmpty()) {
            return true;
        }
        return this.locationIdentities.size() == 1 && this.nodes.get(0) instanceof StartNode;
    }

    @Override
    public MemoryKill getLastLocationAccess(LocationIdentity locationIdentity) {
        if (locationIdentity.isImmutable()) {
            return null;
        }
        int index = this.locationIdentities.indexOf(locationIdentity);
        if (index == -1) {
            index = this.locationIdentities.indexOf(LocationIdentity.any());
        }
        assert (index != -1);
        return (MemoryKill)this.nodes.get(index);
    }

    public Collection<LocationIdentity> getLocations() {
        return this.locationIdentities;
    }

    public EconomicMap<LocationIdentity, MemoryKill> toMap() {
        EconomicMap res = EconomicMap.create((Equivalence)Equivalence.DEFAULT, (int)this.locationIdentities.size());
        for (int i = 0; i < this.nodes.size(); ++i) {
            res.put((Object)this.locationIdentities.get(i), (Object)((MemoryKill)this.nodes.get(i)));
        }
        return res;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }
}

