/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory;

import jdk.graal.compiler.core.common.LIRKind;
import jdk.graal.compiler.core.common.memory.BarrierType;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.memory.MemoryOrderMode;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.lir.gen.BarrierSetLIRGeneratorTool;
import jdk.graal.compiler.lir.gen.ReadBarrierSetLIRGeneratorTool;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeCycles;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodeinfo.NodeSize;
import jdk.graal.compiler.nodes.CanonicalizableLocation;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.FieldLocationIdentity;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.ArrayLengthNode;
import jdk.graal.compiler.nodes.memory.ExtendableMemoryAccess;
import jdk.graal.compiler.nodes.memory.FloatableAccessNode;
import jdk.graal.compiler.nodes.memory.FloatingAccessNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.LIRLowerableAccess;
import jdk.graal.compiler.nodes.memory.MemoryKill;
import jdk.graal.compiler.nodes.memory.OrderedMemoryAccess;
import jdk.graal.compiler.nodes.memory.SingleMemoryKill;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.ArrayLengthProvider;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.NodeLIRBuilderTool;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.spi.Virtualizable;
import jdk.graal.compiler.nodes.spi.VirtualizerTool;
import jdk.graal.compiler.nodes.util.ConstantFoldUtil;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.Value;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Read#{p#location/s}", cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public class ReadNode
extends FloatableAccessNode
implements LIRLowerableAccess,
Canonicalizable,
Virtualizable,
GuardingNode,
OrderedMemoryAccess,
SingleMemoryKill,
ExtendableMemoryAccess,
Simplifiable {
    public static final NodeClass<ReadNode> TYPE = NodeClass.create(ReadNode.class);
    private final Stamp accessStamp;
    private final MemoryOrderMode memoryOrder;
    public final MemoryExtendKind extendKind;

    public ReadNode(AddressNode address, LocationIdentity location, Stamp stamp, BarrierType barrierType, MemoryOrderMode memoryOrder) {
        this(TYPE, address, location, stamp, null, barrierType, memoryOrder, false, null);
    }

    protected ReadNode(NodeClass<? extends ReadNode> c, AddressNode address, LocationIdentity location, Stamp stamp, GuardingNode guard, BarrierType barrierType, MemoryOrderMode memoryOrder, boolean usedAsNullCheck, FrameState stateBefore) {
        this(c, address, location, stamp, MemoryExtendKind.DEFAULT, guard, barrierType, memoryOrder, usedAsNullCheck, stateBefore, null);
    }

    private static Stamp generateStamp(Stamp stamp, MemoryExtendKind extendKind) {
        if (extendKind.isNotExtended()) {
            return stamp;
        }
        return extendKind.stampFor((IntegerStamp)stamp);
    }

    protected ReadNode(NodeClass<? extends ReadNode> c, AddressNode address, LocationIdentity location, Stamp accessStamp, MemoryExtendKind extendKind, GuardingNode guard, BarrierType barrierType, MemoryOrderMode memoryOrder, boolean usedAsNullCheck, FrameState stateBefore, MemoryKill lastLocationAccess) {
        super((NodeClass<? extends FloatableAccessNode>)c, address, location, ReadNode.generateStamp(accessStamp, extendKind), guard, barrierType, usedAsNullCheck, stateBefore);
        this.lastLocationAccess = lastLocationAccess;
        this.accessStamp = accessStamp;
        this.extendKind = extendKind;
        this.memoryOrder = memoryOrder;
        assert (barrierType == BarrierType.NONE || this.stamp.isObjectStamp()) : "incorrect barrier on non-object type: " + String.valueOf(location);
        assert (barrierType == BarrierType.NONE || extendKind == MemoryExtendKind.DEFAULT) : "incorrect extension on barriered access: " + String.valueOf(location);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        BarrierSetLIRGeneratorTool barrierSetLIRGeneratorTool;
        LIRKind readKind = gen.getLIRGeneratorTool().getLIRKind(this.getAccessStamp(NodeView.DEFAULT));
        if (this.getBarrierType() != BarrierType.NONE && (barrierSetLIRGeneratorTool = gen.getLIRGeneratorTool().getBarrierSet()) instanceof ReadBarrierSetLIRGeneratorTool) {
            ReadBarrierSetLIRGeneratorTool barrierSet = (ReadBarrierSetLIRGeneratorTool)barrierSetLIRGeneratorTool;
            assert (this.extendKind == MemoryExtendKind.DEFAULT) : Assertions.errorMessage(new Object[]{this, this.extendKind});
            gen.setResult(this, (Value)barrierSet.emitBarrieredLoad(gen.getLIRGeneratorTool(), readKind, gen.operand(this.address), gen.state(this), this.memoryOrder, this.getBarrierType()));
        } else {
            gen.setResult(this, (Value)gen.getLIRGeneratorTool().getArithmetic().emitLoad(readKind, gen.operand(this.address), gen.state(this), this.memoryOrder, this.extendKind));
        }
    }

    private boolean canCanonicalizeRead() {
        return !this.getUsedAsNullCheck() && !this.extendsAccess();
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (!this.getUsedAsNullCheck() && tool.allUsagesAvailable() && this.hasNoUsages()) {
            return null;
        }
        if (this.canCanonicalizeRead()) {
            return ReadNode.canonicalizeRead(this, this.getAddress(), this.getLocationIdentity(), tool);
        }
        return this;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (!tool.canonicalizeReads() || !this.canCanonicalizeRead()) {
            return;
        }
        if (this.address instanceof OffsetAddressNode) {
            ValueNode length;
            OffsetAddressNode objAddress = (OffsetAddressNode)this.address;
            ConstantReflectionProvider constantReflection = tool.getConstantReflection();
            if (this.getLocationIdentity().equals(NamedLocationIdentity.ARRAY_LENGTH_LOCATION) && (length = GraphUtil.arrayLength(objAddress.getBase(), ArrayLengthProvider.FindLengthMode.CANONICALIZE_READ, constantReflection)) != null) {
                StructuredGraph graph = this.graph();
                ValueNode replacement = ArrayLengthNode.maybeAddPositivePi(length, this);
                graph.replaceFixedWithFloating(this, replacement);
            }
        }
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        if (this.ordersMemoryAccesses()) {
            return LocationIdentity.any();
        }
        return NO_LOCATION;
    }

    @Override
    public FloatingAccessNode asFloatingNode() {
        if (this.ordersMemoryAccesses() || !this.canFloat()) {
            throw GraalError.shouldNotReachHere("Illegal attempt to convert read to floating node.");
        }
        try (DebugCloseable position = this.withNodeSourcePosition();){
            FloatingAccessNode floatingAccessNode = this.graph().unique(new FloatingReadNode(this.getAddress(), this.getLocationIdentity(), this.lastLocationAccess, this.stamp(NodeView.DEFAULT), this.getGuard(), this.getBarrierType()));
            return floatingAccessNode;
        }
    }

    @Override
    public boolean canFloat() {
        if (this.ordersMemoryAccesses()) {
            return false;
        }
        return super.canFloat();
    }

    @Override
    public boolean isAllowedUsageType(InputType type) {
        if (type == InputType.Guard && this.getUsedAsNullCheck()) {
            return true;
        }
        if (type == InputType.Memory && this.ordersMemoryAccesses()) {
            return true;
        }
        return super.isAllowedUsageType(type);
    }

    public static ValueNode canonicalizeRead(ValueNode read, AddressNode address, LocationIdentity locationIdentity, CanonicalizerTool tool) {
        if (!tool.canonicalizeReads()) {
            return read;
        }
        return ReadNode.canonicalizeRead(read, address, locationIdentity, tool, NodeView.from(tool));
    }

    public static ValueNode canonicalizeRead(ValueNode read, AddressNode address, LocationIdentity locationIdentity, CoreProviders tool, NodeView view) {
        if (address instanceof OffsetAddressNode) {
            OffsetAddressNode objAddress = (OffsetAddressNode)address;
            return ReadNode.canonicalizeRead(read, read.stamp(view), objAddress.getBase(), objAddress.getOffset(), locationIdentity, tool, view);
        }
        return read;
    }

    private static ValueNode canonicalizeRead(ValueNode read, Stamp accessStamp, ValueNode object, ValueNode offset, LocationIdentity locationIdentity, CoreProviders tool, NodeView view) {
        MetaAccessProvider metaAccess = tool.getMetaAccess();
        ConstantReflectionProvider constantReflection = tool.getConstantReflection();
        Stamp resultStamp = read.stamp(view);
        if (locationIdentity.equals(NamedLocationIdentity.ARRAY_LENGTH_LOCATION)) {
            ValueNode length = GraphUtil.arrayLength(object, ArrayLengthProvider.FindLengthMode.CANONICALIZE_READ, constantReflection);
            if (length != null && !length.stamp(NodeView.DEFAULT).canBeImprovedWith(StampFactory.positiveInt())) {
                assert (length.stamp(view).isCompatible(accessStamp));
                return length;
            }
        } else if (metaAccess != null && object.isConstant() && !object.isNullConstant() && offset.isConstant()) {
            ResolvedJavaField field;
            ConstantNode constantNode;
            long displacement = offset.asJavaConstant().asLong();
            int stableDimension = ((ConstantNode)object).getStableDimension();
            if (locationIdentity.isImmutable() || stableDimension > 0) {
                boolean isDefaultStable;
                Constant constant = resultStamp.readConstant(constantReflection.getMemoryAccessProvider(), object.asConstant(), displacement, accessStamp);
                boolean bl = isDefaultStable = locationIdentity.isImmutable() || ((ConstantNode)object).isDefaultStable();
                if (constant != null && (isDefaultStable || !constant.isDefaultForKind())) {
                    return ConstantNode.forConstant(resultStamp, constant, Math.max(stableDimension - 1, 0), isDefaultStable, metaAccess);
                }
            }
            if (locationIdentity instanceof FieldLocationIdentity && !locationIdentity.isImmutable() && (constantNode = ConstantFoldUtil.tryConstantFold(tool, field = ((FieldLocationIdentity)locationIdentity).getField(), object.asJavaConstant(), displacement, resultStamp, accessStamp, read.getOptions(), read.getNodeSourcePosition())) != null) {
                return constantNode;
            }
        }
        if (locationIdentity instanceof CanonicalizableLocation) {
            CanonicalizableLocation canonicalize = (CanonicalizableLocation)locationIdentity;
            ValueNode result = canonicalize.canonicalizeRead(read, object, offset, tool);
            assert (result != null);
            assert (result.stamp(view).isCompatible(read.stamp(view))) : Assertions.errorMessageContext("result", result, "read", read);
            return result;
        }
        return read;
    }

    public static ValueNode canonicalizeRead(ValueNode read, CanonicalizerTool tool, JavaKind accessKind, ValueNode object, ValueNode offset, LocationIdentity locationIdentity) {
        if (!tool.canonicalizeReads()) {
            return read;
        }
        NodeView view = NodeView.from(tool);
        Stamp resultStamp = read.stamp(view);
        if (!resultStamp.isCompatible(StampFactory.forKind(accessKind))) {
            return read;
        }
        Stamp accessStamp = resultStamp;
        switch (accessKind) {
            case Boolean: 
            case Byte: {
                accessStamp = IntegerStamp.OPS.getNarrow().foldStamp(32, 8, accessStamp);
                break;
            }
            case Char: 
            case Short: {
                accessStamp = IntegerStamp.OPS.getNarrow().foldStamp(32, 16, accessStamp);
            }
        }
        ValueNode result = ReadNode.canonicalizeRead(read, accessStamp, object, offset, locationIdentity, tool, view);
        if (result.isJavaConstant() && accessKind == JavaKind.Char) {
            PrimitiveStamp primitiveStamp = (PrimitiveStamp)result.stamp(NodeView.DEFAULT);
            result = NarrowNode.create(result, primitiveStamp.getBits(), accessKind.getBitCount(), view);
            return ZeroExtendNode.create(result, primitiveStamp.getBits(), NodeView.DEFAULT);
        }
        return result;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        throw GraalError.shouldNotReachHere("unexpected ReadNode before PEA");
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        if (!this.extendsAccess()) {
            return this.stamp(view);
        }
        return this.accessStamp;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public MemoryExtendKind getExtendKind() {
        return this.extendKind;
    }

    @Override
    public boolean isCompatibleWithExtend() {
        return this.getAccessStamp(NodeView.DEFAULT) instanceof IntegerStamp && !this.extendsAccess();
    }

    @Override
    public boolean isCompatibleWithExtend(MemoryExtendKind newExtendKind) {
        if (this.isCompatibleWithExtend()) {
            return this.getAccessBits() <= newExtendKind.getExtendedBitSize();
        }
        return false;
    }

    @Override
    public int getAccessBits() {
        return ((PrimitiveStamp)this.getAccessStamp(NodeView.DEFAULT)).getBits();
    }

    @Override
    public FixedWithNextNode copyWithExtendKind(MemoryExtendKind newExtendKind) {
        assert (this.isCompatibleWithExtend(newExtendKind));
        return new ReadNode(TYPE, this.address, this.location, this.stamp(NodeView.DEFAULT), newExtendKind, this.guard, this.barrierType, this.memoryOrder, this.usedAsNullCheck, this.stateBefore, this.lastLocationAccess);
    }
}

