/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.memory.address;

import jdk.graal.compiler.core.common.type.AbstractPointerStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.PrimitiveStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodeinfo.NodeInfo;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.AddNode;
import jdk.graal.compiler.nodes.calc.BinaryArithmeticNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(allowedUsageTypes={InputType.Association})
public class OffsetAddressNode
extends AddressNode
implements Canonicalizable {
    public static final NodeClass<OffsetAddressNode> TYPE = NodeClass.create(OffsetAddressNode.class);
    @Node.Input
    ValueNode base;
    @Node.Input
    ValueNode offset;

    public OffsetAddressNode(ValueNode base, ValueNode offset) {
        super((NodeClass<? extends AddressNode>)TYPE);
        this.base = base;
        this.offset = offset;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64) && offset != null && IntegerStamp.getBits(offset.stamp(NodeView.DEFAULT)) == 64) : "both values must have 64 bits";
    }

    public static OffsetAddressNode create(ValueNode base) {
        ConstantNode offset = base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp ? ConstantNode.forIntegerBits(64, 0L) : ConstantNode.forIntegerBits(PrimitiveStamp.getBits(base.stamp(NodeView.DEFAULT)), 0L);
        return new OffsetAddressNode(base, offset);
    }

    @Override
    public ValueNode getBase() {
        return this.base;
    }

    public void setBase(ValueNode base) {
        this.updateUsages(this.base, base);
        this.base = base;
        assert (base != null && (base.stamp(NodeView.DEFAULT) instanceof AbstractPointerStamp || IntegerStamp.getBits(base.stamp(NodeView.DEFAULT)) == 64)) : Assertions.errorMessageContext("this", this, "base", base);
    }

    public ValueNode getOffset() {
        return this.offset;
    }

    public void setOffset(ValueNode offset) {
        this.updateUsages(this.offset, offset);
        this.offset = offset;
        assert (offset != null);
        assert (IntegerStamp.getBits(offset.stamp(NodeView.DEFAULT)) == 64) : Assertions.errorMessageContext("offset", offset, "this", this);
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        AddNode add;
        if (this.base instanceof OffsetAddressNode) {
            NodeView view = NodeView.from(tool);
            OffsetAddressNode b = (OffsetAddressNode)this.base;
            return new OffsetAddressNode(b.getBase(), BinaryArithmeticNode.add(b.getOffset(), this.getOffset(), view));
        }
        if (this.base instanceof AddNode && (add = (AddNode)this.base).getY().isConstant()) {
            return new OffsetAddressNode(add.getX(), new AddNode(add.getY(), this.getOffset()));
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native AddressNode.Address address(Object var0, long var1);

    @Override
    public long getMaxConstantDisplacement() {
        IntegerStamp integerStamp;
        Stamp curStamp = this.offset.stamp(NodeView.DEFAULT);
        if (curStamp instanceof IntegerStamp && (integerStamp = (IntegerStamp)curStamp).lowerBound() >= 0L) {
            return integerStamp.upperBound();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public ValueNode getIndex() {
        return null;
    }
}

