/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.util;

import jdk.graal.compiler.core.common.spi.ConstantFieldProvider;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

public class ConstantFoldUtil {
    public static ConstantNode tryConstantFold(ConstantFieldProvider fieldProvider, final ConstantReflectionProvider constantReflection, final MetaAccessProvider metaAccess, final ResolvedJavaField field, final JavaConstant receiver, final OptionValues options, final Object reason) {
        if (!field.isStatic() && (receiver == null || receiver.isNull())) {
            return null;
        }
        return fieldProvider.readConstantField(field, new ConstantFieldProvider.ConstantFieldTool<ConstantNode>(){

            @Override
            public JavaConstant readValue() {
                return constantReflection.readFieldValue(field, receiver);
            }

            @Override
            public JavaConstant getReceiver() {
                return receiver;
            }

            @Override
            public Object getReason() {
                return reason;
            }

            @Override
            public ConstantNode foldConstant(JavaConstant ret) {
                if (ret != null) {
                    return ConstantNode.forConstant(ret, metaAccess);
                }
                return null;
            }

            @Override
            public ConstantNode foldStableArray(JavaConstant ret, int stableDimensions, boolean isDefaultStable) {
                if (ret != null) {
                    return ConstantNode.forConstant(ret, stableDimensions, isDefaultStable, metaAccess);
                }
                return null;
            }

            @Override
            public OptionValues getOptions() {
                return options;
            }
        });
    }

    public static ConstantNode tryConstantFold(final CoreProviders tool, ResolvedJavaField field, final JavaConstant receiver, final long displacement, final Stamp resultStamp, final Stamp accessStamp, final OptionValues options, final Object reason) {
        if (!field.isStatic() && (receiver == null || receiver.isNull())) {
            return null;
        }
        return tool.getConstantFieldProvider().readConstantField(field, new ConstantFieldProvider.ConstantFieldTool<ConstantNode>(){

            @Override
            public JavaConstant readValue() {
                Constant constant = resultStamp.readConstant(tool.getConstantReflection().getMemoryAccessProvider(), (Constant)receiver, displacement, accessStamp);
                if (constant instanceof JavaConstant) {
                    return (JavaConstant)constant;
                }
                return null;
            }

            @Override
            public JavaConstant getReceiver() {
                return receiver;
            }

            @Override
            public Object getReason() {
                return reason;
            }

            @Override
            public ConstantNode foldConstant(JavaConstant ret) {
                if (ret != null) {
                    return ConstantNode.forConstant(resultStamp, (Constant)ret, tool.getMetaAccess());
                }
                return null;
            }

            @Override
            public ConstantNode foldStableArray(JavaConstant ret, int stableDimensions, boolean isDefaultStable) {
                if (ret != null) {
                    return ConstantNode.forConstant(resultStamp, (Constant)ret, stableDimensions, isDefaultStable, tool.getMetaAccess());
                }
                return null;
            }

            @Override
            public OptionValues getOptions() {
                return options;
            }
        });
    }
}

