/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.nodes.util;

import jdk.graal.compiler.core.common.NumUtil;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerLessThanNode;
import jdk.graal.compiler.nodes.util.IntegerHelper;
import jdk.vm.ci.code.CodeUtil;

public class SignedIntegerHelper
extends IntegerHelper {
    public SignedIntegerHelper(int bits) {
        super(bits);
    }

    @Override
    public long upperBound(IntegerStamp stamp) {
        assert (stamp.getBits() == this.bits) : Assertions.errorMessage(stamp, this.bits);
        return stamp.upperBound();
    }

    @Override
    public long lowerBound(IntegerStamp stamp) {
        assert (stamp.getBits() == this.bits) : Assertions.errorMessage(stamp, this.bits);
        return stamp.lowerBound();
    }

    @Override
    protected int rawCompare(long a, long b) {
        return Long.compare(a, b);
    }

    @Override
    protected long rawMin(long a, long b) {
        return Math.min(a, b);
    }

    @Override
    protected long rawMax(long a, long b) {
        return Math.max(a, b);
    }

    @Override
    public long cast(long a) {
        return CodeUtil.signExtend((long)a, (int)this.bits);
    }

    @Override
    public long minValue() {
        return NumUtil.minValue(this.bits);
    }

    @Override
    public long maxValue() {
        return NumUtil.maxValue(this.bits);
    }

    @Override
    public IntegerStamp stamp(long min, long max) {
        return IntegerStamp.create(this.bits, this.cast(min), this.cast(max));
    }

    @Override
    public LogicNode createCompareNode(ValueNode x, ValueNode y, NodeView view) {
        return IntegerLessThanNode.create(x, y, view);
    }
}

