/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import jdk.graal.compiler.core.common.util.PhasePlan;
import jdk.graal.compiler.debug.TTY;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.PlaceholderPhase;
import jdk.graal.compiler.phases.RecursivePhase;
import jdk.vm.ci.services.Services;

public class PhaseSuite<C>
extends BasePhase<C>
implements PhasePlan<BasePhase<? super C>>,
RecursivePhase {
    private List<BasePhase<? super C>> phases = new ArrayList<BasePhase<? super C>>();
    private boolean immutable;
    private Map<Integer, String> graphStateDiffs;
    private int failureIndex = -1;

    @Override
    public boolean checkContract() {
        return false;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public synchronized void setImmutable() {
        if (!this.immutable) {
            this.phases = Collections.unmodifiableList(this.phases);
            this.immutable = true;
        }
    }

    public final void prependPhase(BasePhase<? super C> phase) {
        this.phases.add(0, phase);
    }

    public final void appendPhase(BasePhase<? super C> phase) {
        this.phases.add(phase);
    }

    public final void addBeforeLast(BasePhase<? super C> phase) {
        ListIterator<BasePhase<C>> last = this.findLastPhase();
        if (last.hasPrevious()) {
            last.previous();
        }
        last.add(phase);
    }

    public final void insertAtIndex(int index, BasePhase<? super C> phase) {
        this.phases.add(index, phase);
    }

    public ListIterator<BasePhase<? super C>> findLastPhase() {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            it.next();
        }
        return it;
    }

    @Override
    public List<BasePhase<? super C>> getPhases() {
        return Collections.unmodifiableList(this.phases);
    }

    @Override
    public String getPhaseName(BasePhase<? super C> phase) {
        return phase.contractorName();
    }

    public String toString() {
        return String.format("%s:%n%s", this.getClass().getSimpleName(), new PhasePlan.Printer().toString(this));
    }

    public final ListIterator<BasePhase<? super C>> findPhase(Class<? extends BasePhase<? super C>> phaseClass) {
        return this.findPhase(phaseClass, false);
    }

    public final ListIterator<BasePhase<? super C>> findPhase(Class<? extends BasePhase<? super C>> phaseClass, boolean recursive) {
        ListIterator<BasePhase<? super C>> it = this.phases.listIterator();
        if (PhaseSuite.findNextPhase(it, phaseClass, recursive)) {
            return it;
        }
        return null;
    }

    public static <C> boolean findNextPhase(ListIterator<BasePhase<? super C>> it, Class<? extends BasePhase<? super C>> phaseClass) {
        return PhaseSuite.findNextPhase(it, phaseClass, false);
    }

    public static <C> boolean findNextPhase(ListIterator<BasePhase<? super C>> it, Class<? extends BasePhase<? super C>> phaseClass, boolean recursive) {
        while (it.hasNext()) {
            PhaseSuite suite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase) || phase instanceof PlaceholderPhase && ((PlaceholderPhase)phase).getPhaseClass().equals(phaseClass)) {
                return true;
            }
            if (!recursive || !(phase instanceof PhaseSuite) || (suite = (PhaseSuite)phase).findPhase(phaseClass, true) == null) continue;
            return true;
        }
        return false;
    }

    public boolean removePhase(Class<? extends BasePhase<? super C>> phaseClass) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                it.remove();
                return true;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).removePhase(phaseClass)) continue;
            if (innerSuite.phases.isEmpty()) {
                it.remove();
            }
            return true;
        }
        return false;
    }

    public boolean removeSubTypePhases(Class<?> type) {
        boolean hasRemovedSpeculativePhase = false;
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<C> phase = it.next();
            if (type.isAssignableFrom(phase.getClass())) {
                it.remove();
                hasRemovedSpeculativePhase = true;
                continue;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).removeSubTypePhases(type)) continue;
            if (innerSuite.phases.isEmpty()) {
                it.remove();
            }
            hasRemovedSpeculativePhase = true;
        }
        return hasRemovedSpeculativePhase;
    }

    public boolean replacePhase(Class<? extends BasePhase<? super C>> phaseClass, BasePhase<? super C> newPhase) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                it.set(newPhase);
                return true;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).replacePhase(phaseClass, newPhase)) continue;
            return true;
        }
        return false;
    }

    public boolean replaceAllPhases(Class<? extends BasePhase<? super C>> phaseClass, Supplier<BasePhase<? super C>> newPhase) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        boolean replaced = false;
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phaseClass.isInstance(phase)) {
                it.set(newPhase.get());
                replaced = true;
                continue;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).replaceAllPhases(phaseClass, newPhase)) continue;
            replaced = true;
        }
        return replaced;
    }

    public boolean replacePlaceholder(Class<? extends BasePhase<? super C>> phaseClass, BasePhase<? super C> phaseInstance) {
        ListIterator<BasePhase<C>> it = this.phases.listIterator();
        while (it.hasNext()) {
            PhaseSuite innerSuite;
            BasePhase<? super C> phase = it.next();
            if (phase instanceof PlaceholderPhase && ((PlaceholderPhase)phase).getPhaseClass().equals(phaseClass)) {
                it.set(phaseInstance);
                return true;
            }
            if (!(phase instanceof PhaseSuite) || !(innerSuite = (PhaseSuite)phase).replacePlaceholder(phaseClass, phaseInstance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mustApply(GraphState graphState) {
        for (BasePhase<C> phase : this.phases) {
            if (!phase.mustApply(graphState)) continue;
            return true;
        }
        return super.mustApply(graphState);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        Formatter cannotApplyBuf = new Formatter();
        GraphState simulationGraphState = graphState.copy();
        for (BasePhase<C> phase : this.getPhases()) {
            String name;
            Optional<BasePhase.NotApplicable> phaseNotApplicable = phase.notApplicableTo(simulationGraphState);
            if (phaseNotApplicable.isPresent() && !(name = phase.getClass().getName()).contains(".svm.") && !name.contains(".truffle.")) {
                cannotApplyBuf.format("%s : %s%n", phase.getClass().getName(), phaseNotApplicable.get().toString());
            }
            try {
                if (phase instanceof PhaseSuite) {
                    ((PhaseSuite)phase).updateGraphStateWithPhases(simulationGraphState);
                    continue;
                }
                phase.updateGraphState(simulationGraphState);
            }
            catch (Throwable t) {
                cannotApplyBuf.format("%s : cannot update the state of the graph.%n", phase.getClass().getName());
                return Optional.of(new BasePhase.NotApplicable(cannotApplyBuf.toString(), t));
            }
        }
        String cannotApply = cannotApplyBuf.toString();
        if (cannotApply.isEmpty()) {
            return ALWAYS_APPLICABLE;
        }
        return Optional.of(new BasePhase.NotApplicable(cannotApply));
    }

    private void updateGraphStateWithPhases(GraphState graphState) {
        for (BasePhase<C> phase : this.getPhases()) {
            if (phase instanceof PhaseSuite) {
                ((PhaseSuite)phase).updateGraphStateWithPhases(graphState);
                continue;
            }
            phase.updateGraphState(graphState);
        }
        this.updateGraphState(graphState);
    }

    @Override
    protected void run(StructuredGraph graph, C context) {
        boolean printGraphStateDiff = Options.PrintGraphStateDiff.getValue(graph.getOptions());
        GraphState graphStateBefore = null;
        if (printGraphStateDiff) {
            graphStateBefore = graph.getGraphState().copy();
        }
        int index = 0;
        for (BasePhase<C> phase : this.phases) {
            try {
                phase.apply(graph, context);
                if (printGraphStateDiff && !graph.getGraphState().equals(graphStateBefore)) {
                    if (this.graphStateDiffs == null) {
                        this.graphStateDiffs = new HashMap<Integer, String>();
                    }
                    this.graphStateDiffs.put(index, graph.getGraphState().updateFromPreviousToString(graphStateBefore));
                    graphStateBefore = graph.getGraphState().copy();
                }
            }
            catch (Throwable t) {
                if (Boolean.parseBoolean(Services.getSavedProperty((String)"test.graal.compilationplan.fuzzing"))) {
                    TTY.println("========================================================================================================================");
                    TTY.println("An error occurred while executing phase %s.", phase.getClass().getName());
                    TTY.printf("The graph state after the failing phase is:%n%s", graph.getGraphState().toString("\t"));
                    TTY.println("========================================================================================================================");
                }
                this.failureIndex = index;
                throw t;
            }
            ++index;
        }
    }

    public PhaseSuite<C> copy() {
        PhaseSuite<C> suite = new PhaseSuite<C>();
        suite.phases.addAll(this.phases);
        return suite;
    }

    @Override
    public String getGraphStateDiff(int position) {
        if (this.graphStateDiffs == null) {
            return null;
        }
        return this.graphStateDiffs.get(position);
    }

    @Override
    public int getFailureIndex() {
        return this.failureIndex;
    }

    public static class Options {
        public static final OptionKey<Boolean> PrintGraphStateDiff = new OptionKey<Boolean>(false);
    }
}

