/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PrefetchAllocateNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.JavaReadNode;
import jdk.graal.compiler.nodes.memory.AbstractWriteNode;
import jdk.graal.compiler.nodes.memory.FloatingReadNode;
import jdk.graal.compiler.nodes.memory.ReadNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.AddressLoweringPhase;
import jdk.vm.ci.meta.JavaKind;

public class AddressLoweringByUsePhase
extends AddressLoweringPhase {
    private final AddressLoweringByUse lowering;

    public AddressLoweringByUsePhase(AddressLoweringByUse lowering) {
        this.lowering = lowering;
        assert (lowering != null);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders providers) {
        for (Node node : graph.getNodes()) {
            AddressNode lowered;
            AddressNode address;
            if (node instanceof ReadNode) {
                ReadNode readNode = (ReadNode)node;
                stamp = readNode.getAccessStamp(NodeView.DEFAULT);
                address = readNode.getAddress();
                lowered = this.lowering.lower(readNode, stamp, address);
            } else if (node instanceof JavaReadNode) {
                JavaReadNode javaReadNode = (JavaReadNode)node;
                stamp = javaReadNode.stamp(NodeView.DEFAULT);
                address = javaReadNode.getAddress();
                lowered = this.lowering.lower(javaReadNode, stamp, address);
            } else if (node instanceof FloatingReadNode) {
                FloatingReadNode floatingReadNode = (FloatingReadNode)node;
                stamp = floatingReadNode.getAccessStamp(NodeView.DEFAULT);
                address = floatingReadNode.getAddress();
                lowered = this.lowering.lower(floatingReadNode, stamp, address);
            } else if (node instanceof AbstractWriteNode) {
                AbstractWriteNode abstractWriteNode = (AbstractWriteNode)node;
                stamp = abstractWriteNode.value().stamp(NodeView.DEFAULT);
                address = abstractWriteNode.getAddress();
                lowered = this.lowering.lower(abstractWriteNode, stamp, address);
            } else {
                if (!(node instanceof PrefetchAllocateNode)) continue;
                PrefetchAllocateNode prefetchAllocateNode = (PrefetchAllocateNode)node;
                stamp = StampFactory.forKind(JavaKind.Object);
                address = (AddressNode)prefetchAllocateNode.inputs().first();
                lowered = this.lowering.lower(prefetchAllocateNode, stamp, address);
            }
            if (lowered == address) continue;
            node.replaceFirstInput(address, lowered);
            if (!address.hasNoUsages()) continue;
            GraphUtil.killWithUnusedFloatingInputs(address);
        }
        for (Node node : graph.getNodes()) {
            if (!(node instanceof OffsetAddressNode)) continue;
            AddressNode address = (AddressNode)node;
            AddressNode lowered = this.lowering.lower(address);
            node.replaceAtUsages(lowered);
            GraphUtil.killWithUnusedFloatingInputs(node);
        }
    }

    public static abstract class AddressLoweringByUse {
        public abstract AddressNode lower(ValueNode var1, Stamp var2, AddressNode var3);

        public abstract AddressNode lower(AddressNode var1);
    }
}

