/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.CounterKey;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.GraalGraphError;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeClass;
import jdk.graal.compiler.graph.NodeFlood;
import jdk.graal.compiler.graph.NodeWorkList;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSinkNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.GuardNode;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.VirtualState;
import jdk.graal.compiler.nodes.WithExceptionNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.spi.Canonicalizable;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;
import jdk.graal.compiler.nodes.spi.Simplifiable;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.IncrementalCanonicalizerPhase;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import org.graalvm.collections.EconomicSet;

public class CanonicalizerPhase
extends BasePhase<CoreProviders> {
    protected static final int MAX_ITERATION_PER_NODE = 10;
    private static final CounterKey COUNTER_CANONICALIZED_NODES = DebugContext.counter("CanonicalizedNodes");
    private static final CounterKey COUNTER_PROCESSED_NODES = DebugContext.counter("ProcessedNodes");
    private static final CounterKey COUNTER_CANONICALIZATION_CONSIDERED_NODES = DebugContext.counter("CanonicalizationConsideredNodes");
    private static final CounterKey COUNTER_INFER_STAMP_CALLED = DebugContext.counter("InferStampCalled");
    private static final CounterKey COUNTER_STAMP_CHANGED = DebugContext.counter("StampChanged");
    private static final CounterKey COUNTER_SIMPLIFICATION_CONSIDERED_NODES = DebugContext.counter("SimplificationConsideredNodes");
    private static final CounterKey COUNTER_CUSTOM_SIMPLIFICATION_CONSIDERED_NODES = DebugContext.counter("CustomSimplificationConsideredNodes");
    protected final EnumSet<CanonicalizerFeature> features;
    protected final CustomSimplification customSimplification;
    private static final int DEAD_PHI_CYCLE_STEPS = 128;

    protected CanonicalizerPhase(EnumSet<CanonicalizerFeature> features) {
        this(null, features);
    }

    protected CanonicalizerPhase() {
        this(null, CanonicalizerPhase.defaultFeatures());
    }

    protected CanonicalizerPhase(CustomSimplification customSimplification) {
        this(customSimplification, CanonicalizerPhase.defaultFeatures());
    }

    protected CanonicalizerPhase(CustomSimplification customSimplification, EnumSet<CanonicalizerFeature> features) {
        this.customSimplification = customSimplification;
        this.features = features;
    }

    public EnumSet<CanonicalizerFeature> getFeatures() {
        return this.features;
    }

    public CanonicalizerPhase copyWithCustomSimplification(CustomSimplification newSimplification) {
        return new CanonicalizerPhase(newSimplification, this.features);
    }

    public CanonicalizerPhase copyWithoutGVN() {
        EnumSet<CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerFeature.GVN);
        return new CanonicalizerPhase(this.customSimplification, newFeatures);
    }

    public CanonicalizerPhase copyWithoutDeadPhiCycleDetection() {
        EnumSet<CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerFeature.DEAD_PHI_CYCLE_DETECTION);
        return new CanonicalizerPhase(this.customSimplification, newFeatures);
    }

    public CanonicalizerPhase copyWithoutSimplification() {
        EnumSet<CanonicalizerFeature> newFeatures = EnumSet.copyOf(this.features);
        newFeatures.remove((Object)CanonicalizerFeature.CFG_SIMPLIFICATION);
        return new CanonicalizerPhase(this.customSimplification, newFeatures);
    }

    public static CanonicalizerPhase create() {
        return new CanonicalizerPhase(null, CanonicalizerPhase.defaultFeatures());
    }

    public static CanonicalizerPhase createWithoutReadCanonicalization() {
        return new CanonicalizerPhase(CanonicalizerPhase.defaultFeaturesWithout(CanonicalizerFeature.READ_CANONICALIZATION));
    }

    public static CanonicalizerPhase createWithoutCFGSimplification() {
        return new CanonicalizerPhase(CanonicalizerPhase.defaultFeaturesWithout(CanonicalizerFeature.CFG_SIMPLIFICATION));
    }

    private static EnumSet<CanonicalizerFeature> defaultFeatures() {
        return EnumSet.allOf(CanonicalizerFeature.class);
    }

    private static EnumSet<CanonicalizerFeature> defaultFeaturesWithout(CanonicalizerFeature feature) {
        EnumSet<CanonicalizerFeature> features = CanonicalizerPhase.defaultFeatures();
        features.remove((Object)feature);
        return features;
    }

    @Override
    public boolean checkContract() {
        return false;
    }

    protected boolean isFinalCanonicalizationPhase() {
        return false;
    }

    @Override
    public boolean mustApply(GraphState graphState) {
        return graphState.requiresFutureStage(GraphState.StageFlag.CANONICALIZATION) || super.mustApply(graphState);
    }

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.FINAL_CANONICALIZATION, graphState), BasePhase.NotApplicable.unlessRunBefore(this, GraphState.StageFlag.REMOVE_OPAQUE_VALUES, graphState));
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        this.processWorkSet(graph, new Tool(graph, context, graph.createIterativeNodeWorkList(true, 10)));
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.removeRequirementToStage(GraphState.StageFlag.CANONICALIZATION);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Graph.Mark newNodesMark) {
        new IncrementalCanonicalizerPhase(this.features, this.customSimplification, graph, context, newNodesMark).apply(graph, context);
    }

    public void applyIncremental(StructuredGraph graph, CoreProviders context, Iterable<? extends Node> workingSet) {
        new IncrementalCanonicalizerPhase(this.features, this.customSimplification, graph, context, workingSet).apply(graph, context);
    }

    private static NodeView getNodeView() {
        return NodeView.DEFAULT;
    }

    @Override
    public int hashCode() {
        if (this.customSimplification == null) {
            return Objects.hash(this.getClass().getName(), this.features.toString());
        }
        return Objects.hash(this.getClass().getName(), this.features.toString(), this.customSimplification.getClass().getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CanonicalizerPhase)) {
            return false;
        }
        CanonicalizerPhase that = (CanonicalizerPhase)obj;
        if (!this.getClass().equals(that.getClass()) || !this.features.equals(that.features)) {
            return false;
        }
        if (this.customSimplification == null) {
            return that.customSimplification == null;
        }
        if (that.customSimplification == null) {
            return false;
        }
        return this.customSimplification.getClass().equals(that.customSimplification.getClass());
    }

    protected int processWorkSet(StructuredGraph graph, final Tool tool) {
        int sum = 0;
        Graph.NodeEventListener listener = new Graph.NodeEventListener(this){

            @Override
            public void nodeAdded(Node node) {
                tool.workList.add(node);
            }

            @Override
            public void inputChanged(Node node) {
                AbstractBeginNode abstractBeginNode;
                tool.workList.add(node);
                if (node instanceof Node.IndirectInputChangedCanonicalization) {
                    for (Node usage : node.usages()) {
                        tool.workList.add(usage);
                    }
                }
                if (node instanceof Node.InputsChangedCanonicalization) {
                    for (Node input : node.inputs()) {
                        tool.workList.add(input);
                    }
                }
                if (node instanceof AbstractBeginNode && (abstractBeginNode = (AbstractBeginNode)node).predecessor() != null) {
                    tool.workList.add(abstractBeginNode.predecessor());
                }
            }

            @Override
            public void usagesDroppedToZero(Node node) {
                tool.workList.add(node);
            }
        };
        try (Graph.NodeEventScope nes = graph.trackNodeEvents(listener);){
            for (Node n : tool.workList) {
                this.processNode(n, tool);
                ++sum;
            }
        }
        EconomicSet phiPostProcessingWorkList = null;
        if (this.features.contains((Object)CanonicalizerFeature.DEAD_PHI_CYCLE_DETECTION) && graph.hasLoops()) {
            for (LoopBeginNode lb : graph.getNodes(LoopBeginNode.TYPE)) {
                for (PhiNode n : lb.phis()) {
                    if (!tool.allUsagesAvailable() || !n.isAlive()) continue;
                    if (phiPostProcessingWorkList == null) {
                        phiPostProcessingWorkList = EconomicSet.create();
                    }
                    phiPostProcessingWorkList.add((Object)n);
                }
            }
        }
        if (tool.allUsagesAvailable() && phiPostProcessingWorkList != null) {
            for (PhiNode phi : phiPostProcessingWorkList) {
                NodeFlood nf;
                if (!phi.isAlive() || !CanonicalizerPhase.isDeadLoopPhiCycle(phi, nf = graph.createNodeFlood())) continue;
                graph.getDebug().dump(5, graph, "Found dead phi cycle %s keeps alive -> %s", phi, nf.getVisited());
                for (Node visitedNode : nf.getVisited()) {
                    if (!(visitedNode instanceof PhiNode)) continue;
                    PhiNode visitedPhi = (PhiNode)visitedNode;
                    for (Node visited : nf.getVisited()) {
                        if (!visited.isAlive() || !visited.hasNoUsages()) continue;
                        GraphUtil.tryKillUnused(visited);
                    }
                    if (!visitedPhi.isAlive()) continue;
                    visitedPhi.replaceAtUsages(null);
                    GraphUtil.killWithUnusedFloatingInputs(visitedPhi, true);
                }
            }
        }
        return sum;
    }

    public static boolean isDeadLoopPhiCycle(PhiNode thisPhi, NodeFlood nf) {
        GraalError.guarantee(thisPhi.isLoopPhi(), "Must only process loop phis");
        nf.add(thisPhi);
        int steps = 0;
        for (Node flooded : nf) {
            if (flooded instanceof ConstantNode) continue;
            if (steps++ >= 128) {
                return false;
            }
            for (Node usage : flooded.usages()) {
                if (usage instanceof GuardNode) {
                    return false;
                }
                if (!GraphUtil.isFloatingNode(usage)) {
                    return false;
                }
                if (usage instanceof VirtualState) {
                    return false;
                }
                if (nf.isMarked(usage)) continue;
                nf.add(usage);
            }
        }
        return true;
    }

    private boolean processNode(Node node, Tool tool) {
        if (!node.isAlive()) {
            return false;
        }
        COUNTER_PROCESSED_NODES.increment(tool.debug);
        StructuredGraph graph = (StructuredGraph)node.graph();
        if (GraphUtil.tryKillUnused(node)) {
            graph.getOptimizationLog().report(5, CanonicalizerPhase.class, "UnusedNodeRemoval", node);
            return true;
        }
        NodeClass<? extends Node> nodeClass = node.getNodeClass();
        if (this.tryCanonicalize(node, nodeClass, tool)) {
            return true;
        }
        if (node instanceof ValueNode) {
            ValueNode valueNode = (ValueNode)node;
            boolean improvedStamp = CanonicalizerPhase.tryInferStamp(valueNode, tool);
            Constant constant = valueNode.stamp(NodeView.DEFAULT).asConstant();
            if (constant != null && !(node instanceof ConstantNode)) {
                ConstantNode stampConstant = ConstantNode.forConstant(valueNode.stamp(NodeView.DEFAULT), constant, tool.context.getMetaAccess(), graph);
                valueNode.replaceAtUsages((Node)stampConstant, InputType.Value);
                GraphUtil.tryKillUnused(valueNode);
                graph.getOptimizationLog().report(CanonicalizerPhase.class, "ConstantStampReplacement", valueNode);
                return true;
            }
            if (improvedStamp) {
                if (this.tryCanonicalize(valueNode, nodeClass, tool)) {
                    return true;
                }
                tool.workList.addAll(valueNode.usages());
            }
        }
        return this.features.contains((Object)CanonicalizerFeature.GVN) && this.tryGlobalValueNumbering(node, nodeClass);
    }

    public static boolean gvn(Node node, NodeClass<?> nodeClass) {
        Node newNode;
        if (nodeClass.valueNumberable() && (newNode = node.graph().findDuplicate(node)) != null) {
            assert (!(node instanceof FixedNode) && !(newNode instanceof FixedNode)) : Assertions.errorMessageContext("node", node, "newNode", newNode);
            node.replaceAtUsagesAndDelete(newNode);
            StructuredGraph graph = (StructuredGraph)node.graph();
            graph.getOptimizationLog().report(CanonicalizerPhase.class, "GlobalValueNumbering", node);
            return true;
        }
        return false;
    }

    public boolean tryGlobalValueNumbering(Node node, NodeClass<?> nodeClass) {
        if (Options.CanonicalizerVerifyGVNAllowed.getValue(node.getOptions()).booleanValue()) assert (((StructuredGraph)node.graph()).getGraphState().isBeforeStage(GraphState.StageFlag.PARTIAL_REDUNDANCY_SCHEDULE)) : "GVN must not occur after expanding partially redundant nodes, trying to gvn " + String.valueOf(node) + " for graph " + String.valueOf(node.graph());
        return CanonicalizerPhase.gvn(node, nodeClass);
    }

    private static AutoCloseable getCanonicalizeableContractAssertion(Node node) {
        boolean needsAssertion = false;
        if (!$assertionsDisabled) {
            needsAssertion = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (needsAssertion) {
            Graph.Mark mark = node.graph().getMark();
            return () -> {
                assert (mark.equals(node.graph().getMark())) : "new node created while canonicalizing " + node.getClass().getSimpleName() + " " + String.valueOf(node) + ": " + String.valueOf(node.graph().getNewNodes(mark).snapshot());
            };
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean tryCanonicalize(Node node, NodeClass<?> nodeClass, Tool tool) {
        try (DebugCloseable position = node.withNodeSourcePosition();){
            DebugContext.Scope scope;
            block35: {
                StructuredGraph graph;
                block36: {
                    block33: {
                        scope = tool.debug.withContext(node);
                        try {
                            if (!nodeClass.isCanonicalizable()) break block33;
                            COUNTER_CANONICALIZATION_CONSIDERED_NODES.increment(tool.debug);
                            Node canonical = node;
                            try (AutoCloseable verify = CanonicalizerPhase.getCanonicalizeableContractAssertion(node);){
                                canonical = ((Canonicalizable)((Object)node)).canonical(tool);
                                if (canonical == node && nodeClass.isCommutative()) {
                                    canonical = ((Canonicalizable.BinaryCommutative)((Object)node)).maybeCommuteInputs();
                                }
                            }
                            catch (Throwable e) {
                                throw new GraalGraphError(e).addContext(node);
                            }
                            if (!CanonicalizerPhase.performReplacement(node, canonical, tool)) break block33;
                            Node finalCanonical = canonical;
                            StructuredGraph graph2 = (StructuredGraph)node.graph();
                            graph2.getOptimizationLog().withLazyProperty("replacedNodeClass", nodeClass::shortName).withLazyProperty("canonicalNodeClass", () -> finalCanonical == null ? null : finalCanonical.getNodeClass().shortName()).report(5, CanonicalizerPhase.class, "CanonicalReplacement", node);
                            boolean bl = true;
                            if (scope != null) {
                                scope.close();
                            }
                            return bl;
                        }
                        catch (Throwable throwable) {
                            if (scope != null) {
                                try {
                                    scope.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    if (!this.features.contains((Object)CanonicalizerFeature.CFG_SIMPLIFICATION)) break block35;
                    if (this.customSimplification == null) break block36;
                    tool.debug.log(3, "Canonicalizer: customSimplification simplifying %s", (Object)node);
                    COUNTER_CUSTOM_SIMPLIFICATION_CONSIDERED_NODES.increment(tool.debug);
                    int modCount = node.graph().getEdgeModificationCount();
                    this.customSimplification.simplify(node, tool);
                    if (!node.isDeleted() && modCount == node.graph().getEdgeModificationCount()) break block36;
                    graph = (StructuredGraph)node.graph();
                    graph.getOptimizationLog().report(5, CanonicalizerPhase.class, "CfgSimplificationCustom", node);
                    boolean bl = true;
                    if (scope != null) {
                        scope.close();
                    }
                    return bl;
                }
                if (!nodeClass.isSimplifiable()) break block35;
                tool.debug.log(3, "Canonicalizer: simplifying %s", (Object)node);
                COUNTER_SIMPLIFICATION_CONSIDERED_NODES.increment(tool.debug);
                int modCount = node.graph().getEdgeModificationCount();
                ((Simplifiable)((Object)node)).simplify(tool);
                if (!node.isDeleted() && modCount == node.graph().getEdgeModificationCount()) break block35;
                graph = (StructuredGraph)node.graph();
                graph.getOptimizationLog().report(5, CanonicalizerPhase.class, "CfgSimplification", node);
                boolean bl = true;
                if (scope != null) {
                    scope.close();
                }
                return bl;
            }
            boolean bl = false;
            if (scope != null) {
                scope.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            throw tool.debug.handle(throwable);
        }
    }

    private static boolean performReplacement(Node node, Node newCanonical, Tool tool) {
        if (newCanonical == node) {
            tool.debug.log(3, "Canonicalizer: work on %1s", (Object)node);
            return false;
        }
        Node canonical = newCanonical;
        tool.debug.log(3, "Canonicalizer: replacing %1s with %1s", (Object)node, (Object)canonical);
        COUNTER_CANONICALIZED_NODES.increment(tool.debug);
        StructuredGraph graph = (StructuredGraph)node.graph();
        if (canonical != null && !canonical.isAlive()) {
            assert (!canonical.isDeleted());
            canonical = graph.addOrUniqueWithInputs(canonical);
        }
        if (node instanceof FloatingNode) {
            assert (canonical == null || !(canonical instanceof FixedNode) || canonical.predecessor() != null || canonical instanceof StartNode || canonical instanceof AbstractMergeNode) : String.valueOf(node) + " -> " + String.valueOf(canonical) + " : replacement should be floating or fixed and connected";
            node.replaceAtUsages(canonical);
            GraphUtil.killWithUnusedFloatingInputs(node, true);
        } else {
            assert (node instanceof FixedNode && node.predecessor() != null) : String.valueOf(node) + " -> " + String.valueOf(canonical) + " : node should be fixed & connected (" + String.valueOf(node.predecessor()) + ")";
            FixedNode fixed = (FixedNode)node;
            if (canonical instanceof ControlSinkNode) {
                fixed.replaceAtPredecessor(canonical);
                GraphUtil.killCFG(fixed);
                return true;
            }
            if (fixed instanceof WithExceptionNode) {
                WithExceptionNode withException = (WithExceptionNode)fixed;
                assert (withException.next() != null);
                tool.addToWorkList(withException.next());
                if (canonical == null) {
                    node.replaceAtUsages(null);
                    GraphUtil.unlinkAndKillExceptionEdge(withException);
                    GraphUtil.killWithUnusedFloatingInputs(withException);
                } else if (canonical instanceof FloatingNode) {
                    FloatingNode floating = (FloatingNode)canonical;
                    AbstractBeginNode exceptionEdge = withException.exceptionEdge();
                    withException.setExceptionEdge(null);
                    graph.replaceSplitWithFloating(withException, floating, withException.next());
                    if (exceptionEdge != null) {
                        GraphUtil.killCFG(exceptionEdge);
                    }
                } else {
                    assert (canonical instanceof FixedNode) : Assertions.errorMessage(canonical);
                    if (canonical.predecessor() == null) {
                        assert (!canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + String.valueOf(canonical) + " shouldn't have successors";
                        if (canonical instanceof WithExceptionNode) {
                            graph.replaceWithExceptionSplit(withException, (WithExceptionNode)canonical);
                        } else {
                            withException.killExceptionEdge();
                            graph.replaceSplitWithFixed(withException, (FixedWithNextNode)canonical, withException.next());
                        }
                    } else {
                        assert (canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + String.valueOf(canonical) + " should have successors";
                        node.replaceAtUsages(canonical);
                        GraphUtil.unlinkAndKillExceptionEdge(withException);
                        GraphUtil.killWithUnusedFloatingInputs(withException);
                    }
                }
            } else {
                assert (fixed instanceof FixedWithNextNode) : Assertions.errorMessage(fixed);
                FixedWithNextNode fixedWithNext = (FixedWithNextNode)fixed;
                assert (fixedWithNext.next() != null);
                tool.addToWorkList(fixedWithNext.next());
                if (canonical == null) {
                    node.replaceAtUsages(null);
                    GraphUtil.removeFixedWithUnusedInputs(fixedWithNext);
                } else if (canonical instanceof FloatingNode) {
                    graph.replaceFixedWithFloating(fixedWithNext, (FloatingNode)canonical);
                } else {
                    assert (canonical instanceof FixedNode) : Assertions.errorMessage(canonical);
                    if (canonical.predecessor() == null) {
                        assert (!canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + String.valueOf(canonical) + " shouldn't have successors";
                        graph.replaceFixedWithFixed(fixedWithNext, (FixedWithNextNode)canonical);
                    } else {
                        assert (canonical.cfgSuccessors().iterator().hasNext()) : "replacement " + String.valueOf(canonical) + " should have successors";
                        node.replaceAtUsages(canonical);
                        GraphUtil.removeFixedWithUnusedInputs(fixedWithNext);
                    }
                }
            }
        }
        return true;
    }

    private static boolean tryInferStamp(ValueNode node, Tool tool) {
        if (node.isAlive()) {
            COUNTER_INFER_STAMP_CALLED.increment(tool.debug);
            if (node.inferStamp()) {
                COUNTER_STAMP_CHANGED.increment(tool.debug);
                for (Node usage : node.usages()) {
                    tool.workList.add(usage);
                }
                return true;
            }
        }
        return false;
    }

    public boolean getCanonicalizeReads() {
        return this.features.contains((Object)CanonicalizerFeature.READ_CANONICALIZATION);
    }

    public static interface CustomSimplification {
        public void simplify(Node var1, SimplifierTool var2);
    }

    public static enum CanonicalizerFeature {
        READ_CANONICALIZATION,
        CFG_SIMPLIFICATION,
        GVN,
        DEAD_PHI_CYCLE_DETECTION;

    }

    protected final class Tool
    extends CoreProvidersDelegate
    implements SimplifierTool,
    NodeView {
        private final Assumptions assumptions;
        private final OptionValues options;
        private final CoreProviders context;
        private final NodeWorkList workList;
        private final NodeView nodeView;
        private final DebugContext debug;

        Tool(StructuredGraph graph, CoreProviders context, NodeWorkList workList) {
            super(context);
            this.debug = graph.getDebug();
            this.assumptions = graph.getAssumptions();
            this.options = graph.getOptions();
            this.nodeView = CanonicalizerPhase.getNodeView();
            this.context = context;
            this.workList = workList;
        }

        @Override
        public void deleteBranch(Node branch) {
            FixedNode fixedBranch = (FixedNode)branch;
            fixedBranch.predecessor().replaceFirstSuccessor(fixedBranch, null);
            GraphUtil.killCFG(fixedBranch);
        }

        @Override
        public void addToWorkList(Node node) {
            this.workList.add(node);
        }

        @Override
        public void addToWorkList(Iterable<? extends Node> nodes) {
            this.workList.addAll(nodes);
        }

        @Override
        public void removeIfUnused(Node node) {
            GraphUtil.tryKillUnused(node);
        }

        @Override
        public boolean canonicalizeReads() {
            return CanonicalizerPhase.this.features.contains((Object)CanonicalizerFeature.READ_CANONICALIZATION);
        }

        @Override
        public boolean finalCanonicalization() {
            return CanonicalizerPhase.this.isFinalCanonicalizationPhase();
        }

        @Override
        public boolean allUsagesAvailable() {
            return true;
        }

        @Override
        public boolean trySinkWriteFences() {
            return this.context.getLowerer().writesStronglyOrdered();
        }

        @Override
        public Assumptions getAssumptions() {
            return this.assumptions;
        }

        @Override
        public Integer smallestCompareWidth() {
            return this.context.getLowerer().smallestCompareWidth();
        }

        @Override
        public boolean supportsRounding() {
            return this.context.getLowerer().supportsRounding();
        }

        @Override
        public OptionValues getOptions() {
            return this.options;
        }

        @Override
        public Stamp stamp(ValueNode node) {
            return this.nodeView.stamp(node);
        }

        @Override
        public boolean divisionOverflowIsJVMSCompliant() {
            return this.context.getLowerer().divisionOverflowIsJVMSCompliant();
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> CanonicalizerVerifyGVNAllowed = new OptionKey<Boolean>(true);
    }
}

