/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import jdk.graal.compiler.core.common.cfg.Loop;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.debug.DebugCloseable;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.DynamicDeoptimizeNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.LoopExitNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.cfg.ControlFlowGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.MidTierContext;

public class DeoptimizationGroupingPhase
extends BasePhase<MidTierContext> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        ControlFlowGraph cfg = null;
        for (FrameState fs : graph.getNodes(FrameState.TYPE)) {
            Iterator iterator = fs.usages().filter(AbstractDeoptimizeNode.class).iterator();
            if (!iterator.hasNext()) continue;
            AbstractDeoptimizeNode first = (AbstractDeoptimizeNode)iterator.next();
            if (!iterator.hasNext()) continue;
            if (cfg == null) {
                cfg = ControlFlowGraph.newBuilder(graph).connectBlocks(true).computeLoops(true).computeFrequency(true).build();
            }
            DebugCloseable position = first.withNodeSourcePosition();
            try {
                AbstractMergeNode merge = graph.add(new MergeNode());
                EndNode firstEnd = graph.add(new EndNode());
                ValueNode actionAndReason = first.getActionAndReason(context.getMetaAccess());
                ValueNode speculation = first.getSpeculation(context.getMetaAccess());
                PhiNode reasonActionPhi = graph.addWithoutUnique(new ValuePhiNode(StampFactory.forKind(actionAndReason.getStackKind()), merge));
                PhiNode speculationPhi = graph.addWithoutUnique(new ValuePhiNode(StampFactory.forKind(speculation.getStackKind()), merge));
                merge.addForwardEnd(firstEnd);
                reasonActionPhi.addInput(actionAndReason);
                speculationPhi.addInput(speculation);
                first.replaceAtPredecessor(firstEnd);
                DeoptimizationGroupingPhase.exitLoops(first, firstEnd, cfg);
                DynamicDeoptimizeNode dynamicDeopt = new DynamicDeoptimizeNode(reasonActionPhi, speculationPhi);
                merge.setNext(graph.add(dynamicDeopt));
                LinkedList<AbstractDeoptimizeNode> obsoletes = new LinkedList<AbstractDeoptimizeNode>();
                obsoletes.add(first);
                do {
                    AbstractDeoptimizeNode deopt = (AbstractDeoptimizeNode)iterator.next();
                    EndNode newEnd = graph.add(new EndNode());
                    merge.addForwardEnd(newEnd);
                    reasonActionPhi.addInput(deopt.getActionAndReason(context.getMetaAccess()));
                    speculationPhi.addInput(deopt.getSpeculation(context.getMetaAccess()));
                    deopt.replaceAtPredecessor(newEnd);
                    DeoptimizationGroupingPhase.exitLoops(deopt, newEnd, cfg);
                    obsoletes.add(deopt);
                } while (iterator.hasNext());
                dynamicDeopt.setStateBefore(fs);
                for (AbstractDeoptimizeNode obsolete : obsoletes) {
                    obsolete.safeDelete();
                }
                graph.getOptimizationLog().report(this.getClass(), "DeoptimizationGrouping", first);
            }
            finally {
                if (position == null) continue;
                position.close();
            }
        }
    }

    private static void exitLoops(AbstractDeoptimizeNode deopt, EndNode end, ControlFlowGraph cfg) {
        HIRBlock block = cfg.blockFor(deopt);
        for (Loop<HIRBlock> loop = block.getLoop(); loop != null; loop = loop.getParent()) {
            end.graph().addBeforeFixed(end, end.graph().add(new LoopExitNode((LoopBeginNode)loop.getHeader().getBeginNode())));
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 2.5f;
    }
}

