/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.LoopBeginNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.Phase;

public class DisableOverflownCountedLoopsPhase
extends Phase {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return ALWAYS_APPLICABLE;
    }

    @Override
    public boolean shouldApply(StructuredGraph graph) {
        return graph.hasLoops();
    }

    @Override
    protected void run(StructuredGraph graph) {
        for (LoopBeginNode lb : graph.getNodes(LoopBeginNode.TYPE)) {
            if (lb.countedLoopDisabled()) continue;
            lb.checkDisableCountedBySpeculation(lb.stateAfter().bci, graph);
        }
    }
}

