/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.List;
import java.util.Optional;
import jdk.graal.compiler.core.common.memory.MemoryExtendKind;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.debug.Assertions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.IntegerConvertNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.memory.ExtendableMemoryAccess;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public class OptimizeExtendsPhase
extends BasePhase<LowTierContext> {
    private static final int UNSET = -1;

    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.FINAL_CANONICALIZATION, graphState);
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        if (!context.getLowerer().narrowsUseCastValue()) {
            return;
        }
        int origNumExtends = 0;
        EconomicSet defsWithExtends = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (Node node : graph.getNodes().filter(OptimizeExtendsPhase::isExtendNode)) {
            IntegerConvertNode extend = (IntegerConvertNode)node;
            ++origNumExtends;
            assert (extend.getInputBits() < extend.getResultBits()) : Assertions.errorMessage(extend);
            defsWithExtends.add((Object)extend.getValue());
        }
        EconomicMap extendReplacements = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        for (ValueNode origDef : defsWithExtends) {
            int inputBitsSize = -1;
            int maxZeroExtend = -1;
            int maxSignExtend = -1;
            ValueNode def = origDef;
            if (def instanceof IntegerConvertNode && extendReplacements.containsKey((Object)def)) {
                def = (ValueNode)extendReplacements.get((Object)def);
            }
            List uses = def.usages().filter(OptimizeExtendsPhase::isExtendNode).snapshot();
            boolean hasRedundantExtends = false;
            for (Node n : uses) {
                IntegerConvertNode use = (IntegerConvertNode)n;
                int inputBits = use.getInputBits();
                int resultBits = use.getResultBits();
                if (inputBitsSize == -1) {
                    inputBitsSize = inputBits;
                } else {
                    GraalError.guarantee(inputBitsSize == inputBits, "Unexpected input bits size: %s. Expected size: %s", (Object)inputBits, (Object)inputBitsSize);
                }
                if (use instanceof ZeroExtendNode) {
                    hasRedundantExtends |= maxZeroExtend != -1;
                    maxZeroExtend = Integer.max(maxZeroExtend, resultBits);
                    continue;
                }
                assert (use instanceof SignExtendNode) : Assertions.errorMessageContext("use", use);
                hasRedundantExtends |= maxSignExtend != -1;
                maxSignExtend = Integer.max(maxSignExtend, resultBits);
            }
            if (!(def instanceof ExtendableMemoryAccess) && !hasRedundantExtends) continue;
            ValueNode newZeroExtend = null;
            ValueNode newSignExtend = null;
            ValueNode extendInput = def;
            if (def instanceof ExtendableMemoryAccess) {
                MemoryExtendKind extendKind;
                ExtendableMemoryAccess access = (ExtendableMemoryAccess)((Object)def);
                FixedWithNextNode extendedDef = null;
                MemoryExtendKind memoryExtendKind = extendKind = maxZeroExtend == -1 ? MemoryExtendKind.DEFAULT : MemoryExtendKind.getZeroExtendKind(maxZeroExtend);
                if (extendKind.isExtended() && context.getLowerer().supportsFoldingExtendIntoAccess(access, extendKind)) {
                    extendedDef = graph.add(access.copyWithExtendKind(extendKind));
                    newZeroExtend = extendedDef;
                } else {
                    MemoryExtendKind memoryExtendKind2 = extendKind = maxSignExtend == -1 ? MemoryExtendKind.DEFAULT : MemoryExtendKind.getSignExtendKind(maxSignExtend);
                    if (extendKind.isExtended() && context.getLowerer().supportsFoldingExtendIntoAccess(access, extendKind)) {
                        extendedDef = graph.add(access.copyWithExtendKind(extendKind));
                        newSignExtend = extendedDef;
                    }
                }
                if (extendedDef != null) {
                    extendInput = graph.addOrUnique(new NarrowNode(extendedDef, inputBitsSize));
                    def.replaceAtUsages((Node)extendInput, InputType.Value);
                    graph.replaceFixedWithFixed(access.asFixedWithNextNode(), extendedDef);
                }
            }
            if (extendInput == def && !hasRedundantExtends) continue;
            if (maxZeroExtend != -1 && newZeroExtend == null) {
                newZeroExtend = graph.addOrUnique(new ZeroExtendNode(extendInput, inputBitsSize, maxZeroExtend));
            }
            if (maxSignExtend != -1 && newSignExtend == null) {
                newSignExtend = graph.addOrUnique(new SignExtendNode(extendInput, inputBitsSize, maxSignExtend));
            }
            for (Node n : uses) {
                ValueNode replacement;
                int replacementBits;
                IntegerConvertNode use = (IntegerConvertNode)n;
                if (use instanceof ZeroExtendNode) {
                    assert (newZeroExtend != null);
                    replacementBits = maxZeroExtend;
                    replacement = newZeroExtend;
                } else {
                    assert (newSignExtend != null);
                    replacementBits = maxSignExtend;
                    replacement = newSignExtend;
                }
                int resultBits = use.getResultBits();
                if (resultBits != replacementBits) {
                    assert (replacementBits > resultBits) : replacementBits + " " + resultBits;
                    replacement = graph.addOrUnique(new NarrowNode(replacement, replacementBits, resultBits));
                }
                if (use == replacement) continue;
                use.replaceAtUsagesAndDelete(replacement);
                if (!defsWithExtends.contains((Object)use)) continue;
                extendReplacements.put((Object)use, (Object)replacement);
            }
            if (extendInput == def || !extendInput.hasNoUsages()) continue;
            extendInput.safeDelete();
        }
        if (Assertions.assertionsEnabled()) {
            int n = graph.getNodes().filter(OptimizeExtendsPhase::isExtendNode).count();
            assert (n <= origNumExtends) : n + " " + origNumExtends;
        }
    }

    private static boolean isExtendNode(Node node) {
        return (node instanceof ZeroExtendNode || node instanceof SignExtendNode) && ((IntegerConvertNode)node).stamp(NodeView.DEFAULT) instanceof IntegerStamp;
    }
}

