/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.graph.NodeStack;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.AbstractDeoptimizeNode;
import jdk.graal.compiler.nodes.AbstractEndNode;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;

public class PropagateDeoptimizeProbabilityPhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.when(!graphState.getGuardsStage().areDeoptsFixed(), "%s expects fixed deopts", this.getName());
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        if (graph.hasNode(AbstractDeoptimizeNode.TYPE)) {
            NodeStack stack = new NodeStack();
            EconomicMap reachableSplits = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
            for (AbstractDeoptimizeNode d : graph.getNodes(AbstractDeoptimizeNode.TYPE)) {
                stack.push(AbstractBeginNode.prevBegin(d));
                while (!stack.isEmpty()) {
                    AbstractBeginNode beginNode = (AbstractBeginNode)stack.pop();
                    FixedNode fixedNode = (FixedNode)beginNode.predecessor();
                    if (fixedNode == null) continue;
                    if (fixedNode instanceof AbstractMergeNode) {
                        AbstractMergeNode mergeNode = (AbstractMergeNode)fixedNode;
                        for (AbstractEndNode abstractEndNode : mergeNode.forwardEnds()) {
                            AbstractBeginNode newBeginNode = AbstractBeginNode.prevBegin(abstractEndNode);
                            stack.push(newBeginNode);
                        }
                        continue;
                    }
                    if (fixedNode instanceof ControlSplitNode) {
                        ControlSplitNode controlSplitNode = (ControlSplitNode)fixedNode;
                        EconomicSet reachableSuccessors = (EconomicSet)reachableSplits.get((Object)controlSplitNode);
                        if (reachableSuccessors == null) {
                            reachableSuccessors = EconomicSet.create();
                            reachableSplits.put((Object)controlSplitNode, (Object)reachableSuccessors);
                        }
                        if (controlSplitNode.getSuccessorCount() == reachableSuccessors.size() - 1) {
                            reachableSplits.removeKey((Object)controlSplitNode);
                            stack.push(AbstractBeginNode.prevBegin((FixedNode)controlSplitNode.predecessor()));
                            continue;
                        }
                        reachableSuccessors.add((Object)beginNode);
                        continue;
                    }
                    stack.push(AbstractBeginNode.prevBegin(fixedNode));
                }
            }
            MapCursor entries = reachableSplits.getEntries();
            while (entries.advance()) {
                ControlSplitNode controlSplitNode = (ControlSplitNode)entries.getKey();
                EconomicSet value = (EconomicSet)entries.getValue();
                for (AbstractBeginNode begin : value) {
                    double probability = controlSplitNode.probability(begin);
                    if (probability == 0.0) continue;
                    controlSplitNode.setProbability(begin, BranchProbabilityNode.DEOPT_PROFILE);
                }
            }
        }
    }
}

