/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.FixReadsPhase;
import jdk.graal.compiler.phases.schedule.SchedulePhase;
import jdk.graal.compiler.phases.tiers.LowTierContext;

public class RawConditionalEliminationPhase
extends BasePhase<LowTierContext> {
    private final boolean replaceInputsWithConstants;

    public RawConditionalEliminationPhase(boolean replaceInputsWithConstants) {
        this.replaceInputsWithConstants = replaceInputsWithConstants;
    }

    @Override
    protected void run(StructuredGraph graph, LowTierContext context) {
        if (GraalOptions.RawConditionalElimination.getValue(graph.getOptions()).booleanValue()) {
            SchedulePhase schedulePhase = new SchedulePhase(SchedulePhase.SchedulingStrategy.LATEST, true);
            schedulePhase.apply(graph, context);
            StructuredGraph.ScheduleResult schedule = graph.getLastSchedule();
            schedule.getCFG().visitDominatorTree(new FixReadsPhase.RawConditionalEliminationVisitor(graph, schedule, context.getMetaAccess(), this.replaceInputsWithConstants), false);
        }
    }
}

