/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common;

import java.util.Optional;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.extended.OpaqueValueNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.BasePhase;

public class RemoveOpaqueValuePhase
extends BasePhase<CoreProviders> {
    @Override
    public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
        return BasePhase.NotApplicable.ifAny(BasePhase.NotApplicable.unlessRunAfter(this, GraphState.StageFlag.LOW_TIER_LOWERING, graphState), BasePhase.NotApplicable.ifApplied(this, GraphState.StageFlag.REMOVE_OPAQUE_VALUES, graphState));
    }

    @Override
    public boolean shouldApply(StructuredGraph graph) {
        return graph.hasNode(OpaqueValueNode.TYPE);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (OpaqueValueNode opaque : graph.getNodes(OpaqueValueNode.TYPE)) {
            opaque.replaceAtUsagesAndDelete(opaque.getValue());
        }
    }

    @Override
    public void updateGraphState(GraphState graphState) {
        super.updateGraphState(graphState);
        graphState.setAfterStage(GraphState.StageFlag.REMOVE_OPAQUE_VALUES);
    }
}

