/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.info;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.ExactInlineInfo;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicSet;

public class AssumptionInlineInfo
extends ExactInlineInfo {
    private final Assumptions.AssumptionResult<?> takenAssumption;

    public AssumptionInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, Assumptions.AssumptionResult<?> takenAssumption) {
        super(invoke, concrete);
        this.takenAssumption = takenAssumption;
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        this.takenAssumption.recordTo(this.invoke.asNode().graph().getAssumptions());
        return super.inline(providers, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        this.takenAssumption.recordTo(this.invoke.asNode().graph().getAssumptions());
        InliningUtil.replaceInvokeCallTarget(this.invoke, this.graph(), CallTargetNode.InvokeKind.Special, this.concrete);
    }

    @Override
    public String toString() {
        return "assumption " + this.concrete.format("%H.%n(%p):%r");
    }
}

