/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.common.inlining.info;

import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.phases.common.inlining.info.AbstractInlineInfo;
import jdk.graal.compiler.phases.common.inlining.info.elem.Inlineable;
import jdk.graal.compiler.phases.util.Providers;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import org.graalvm.collections.EconomicSet;

public class TypeGuardInlineInfo
extends AbstractInlineInfo {
    private final ResolvedJavaMethod concrete;
    private final ResolvedJavaType type;
    private Inlineable inlineableElement;
    private final SpeculationLog.Speculation speculation;

    public TypeGuardInlineInfo(Invoke invoke, ResolvedJavaMethod concrete, ResolvedJavaType type, SpeculationLog.Speculation speculation) {
        super(invoke);
        this.concrete = concrete;
        this.type = type;
        assert (type.isArray() || type.isConcrete()) : type;
        this.speculation = speculation;
    }

    @Override
    public int numberOfMethods() {
        return 1;
    }

    @Override
    public ResolvedJavaMethod methodAt(int index) {
        assert (index == 0) : index;
        return this.concrete;
    }

    @Override
    public Inlineable inlineableElementAt(int index) {
        assert (index == 0) : index;
        return this.inlineableElement;
    }

    @Override
    public double probabilityAt(int index) {
        assert (index == 0) : index;
        return 1.0;
    }

    @Override
    public double relevanceAt(int index) {
        assert (index == 0) : index;
        return 1.0;
    }

    @Override
    public void setInlinableElement(int index, Inlineable inlineableElement) {
        assert (index == 0) : index;
        this.inlineableElement = inlineableElement;
    }

    @Override
    public EconomicSet<Node> inline(CoreProviders providers, String reason) {
        InliningUtil.insertTypeGuard(providers, this.invoke, this.type, this.speculation);
        return TypeGuardInlineInfo.inline(this.invoke, this.concrete, this.inlineableElement, false, reason);
    }

    @Override
    public void tryToDevirtualizeInvoke(Providers providers) {
        InliningUtil.insertTypeGuard(providers, this.invoke, this.type, this.speculation);
        InliningUtil.replaceInvokeCallTarget(this.invoke, this.graph(), CallTargetNode.InvokeKind.Special, this.concrete);
    }

    public String toString() {
        return "type-checked with type " + this.type.getName() + " and method " + this.concrete.format("%H.%n(%p):%r");
    }

    @Override
    public boolean shouldInline() {
        return this.concrete.shouldBeInlined();
    }
}

