/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.phases.tiers;

import jdk.graal.compiler.java.GraphBuilderPhase;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import jdk.graal.compiler.nodes.spi.CoreProvidersDelegate;
import jdk.graal.compiler.phases.OptimisticOptimizations;
import jdk.graal.compiler.phases.PhaseSuite;
import jdk.graal.compiler.phases.util.Providers;

public class HighTierContext
extends CoreProvidersDelegate {
    private final PhaseSuite<HighTierContext> graphBuilderSuite;
    private final OptimisticOptimizations optimisticOpts;

    public HighTierContext(Providers providers, PhaseSuite<HighTierContext> graphBuilderSuite, OptimisticOptimizations optimisticOpts) {
        super(providers);
        this.graphBuilderSuite = graphBuilderSuite;
        this.optimisticOpts = optimisticOpts;
    }

    public PhaseSuite<HighTierContext> getGraphBuilderSuite() {
        return this.graphBuilderSuite;
    }

    public PhaseSuite<HighTierContext> getGraphBuilderSuiteForCallee(Invoke invoke) {
        PhaseSuite<HighTierContext> regularGraphBuilder = this.graphBuilderSuite;
        if (invoke.isInOOMETry()) {
            PhaseSuite<HighTierContext> copied = regularGraphBuilder.copy();
            GraphBuilderPhase originalBuilder = (GraphBuilderPhase)copied.findPhase(GraphBuilderPhase.class).previous();
            GraphBuilderConfiguration newConfig = originalBuilder.getGraphBuilderConfig().copy().withOOMEExceptionEdges(GraphBuilderConfiguration.ExplicitOOMEExceptionEdges.ForceOOMEExceptionEdges);
            copied.findPhase(GraphBuilderPhase.class).set(originalBuilder.copyWithConfig(newConfig));
            return copied;
        }
        return regularGraphBuilder;
    }

    public OptimisticOptimizations getOptimisticOptimizations() {
        return this.optimisticOpts;
    }

    @Override
    public Providers getProviders() {
        return (Providers)super.getProviders();
    }
}

